/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.measure.Calibration;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.util.Vector;
import sc.fiji.i5d.ChannelImagePlus;
import sc.fiji.i5d.Image5D;
import sc.fiji.i5d.gui.ChannelControl;
import sc.fiji.i5d.gui.Image5DCanvas;
import sc.fiji.i5d.gui.Image5DLayout;
import sc.fiji.i5d.gui.ScrollbarWithLabel;

public class Image5DWindow
extends StackWindow
implements KeyListener {
    private static final long serialVersionUID = -3196514227677416036L;
    protected ChannelControl channelControl;
    protected ScrollbarWithLabel[] scrollbarsWL;
    protected Image5D i5d;
    protected Vector<Image5DCanvas> channelCanvasses = new Vector();
    protected int[] positions;
    protected int nDimensions = 5;
    protected int[] dimensions;
    protected boolean isInitialized = false;
    protected int displayMode;
    protected boolean displayGrayInTiles;

    public Image5DWindow(Image5D imp) {
        this(imp, new Image5DCanvas(imp));
    }

    public Image5DWindow(Image5D imp, Image5DCanvas ic) {
        super((ImagePlus)imp, (ImageCanvas)ic);
        int i;
        int i2;
        if (ic == null) {
            throw new IllegalArgumentException("Image5DCanvas must not be null.");
        }
        this.i5d = imp;
        if (imp.getNDimensions() != this.nDimensions) {
            throw new IllegalArgumentException("Wrong number of dimensions.");
        }
        this.scrollbarsWL = new ScrollbarWithLabel[this.nDimensions];
        this.positions = new int[this.nDimensions];
        this.dimensions = this.i5d.getDimensions();
        this.removeAll();
        this.setLayout(new Image5DLayout(ic));
        this.displayMode = 1;
        this.add((Component)((Object)ic), "main");
        for (i2 = 1; i2 <= this.i5d.getNChannels(); ++i2) {
            this.channelCanvasses.add(new Image5DCanvas(this.i5d.getChannelImagePlus(i2)));
            this.i5d.getChannelImagePlus(i2).setWindow((ImageWindow)this);
        }
        this.channelControl = new ChannelControl(this);
        this.add(this.channelControl, "channel");
        this.scrollbarsWL[3] = new ScrollbarWithLabel(0, 1, 1, 1, this.dimensions[3] + 1, imp.getDimensionLabel(3));
        if (this.i5d.getNSlices() > 1) {
            this.add(this.scrollbarsWL[3], "slice");
        }
        this.scrollbarsWL[4] = new ScrollbarWithLabel(0, 1, 1, 1, this.dimensions[4] + 1, imp.getDimensionLabel(4));
        if (this.i5d.getNFrames() > 1) {
            this.add(this.scrollbarsWL[4], "frame");
        }
        for (i2 = 3; i2 < this.nDimensions; ++i2) {
            this.scrollbarsWL[i2].addAdjustmentListener((AdjustmentListener)((Object)this));
            this.scrollbarsWL[i2].setFocusable(false);
            int blockIncrement = this.dimensions[i2] / 10;
            if (blockIncrement < 1) {
                blockIncrement = 1;
            }
            this.scrollbarsWL[i2].setUnitIncrement(1);
            this.scrollbarsWL[i2].setBlockIncrement(blockIncrement);
        }
        this.sliceSelector = this.scrollbarsWL[3].getScrollbar();
        this.setDisplayGrayInTiles(this.i5d.isDisplayGrayInTiles());
        this.setDisplayMode(this.i5d.getDisplayMode());
        this.pack();
        this.isInitialized = true;
        this.updateSliceSelector();
        this.i5d.updateAndRepaintWindow();
        this.i5d.updateImageAndDraw();
        this.done = true;
        this.thread.interrupt();
        while (this.thread.isAlive()) {
        }
        this.done = false;
        this.thread = new Thread((Runnable)((Object)this), "SliceSelector");
        this.thread.start();
        ImageJ ij = IJ.getInstance();
        this.removeKeyListener((KeyListener)ij);
        ic.removeKeyListener((KeyListener)ij);
        for (i = 0; i < this.i5d.getNChannels(); ++i) {
            this.channelCanvasses.get(i).removeKeyListener((KeyListener)ij);
        }
        this.addKeyListener(this);
        ic.addKeyListener(this);
        for (i = 0; i < this.i5d.getNChannels(); ++i) {
            this.channelCanvasses.get(i).addKeyListener(this);
        }
        this.scrollbarsWL[3].addKeyListener(this);
        this.scrollbarsWL[4].addKeyListener(this);
        this.addKeyListener((KeyListener)ij);
        ic.addKeyListener((KeyListener)ij);
        for (i = 0; i < this.i5d.getNChannels(); ++i) {
            this.channelCanvasses.get(i).addKeyListener((KeyListener)ij);
        }
        this.scrollbarsWL[3].addKeyListener((KeyListener)ij);
        this.scrollbarsWL[4].addKeyListener((KeyListener)ij);
        this.addKeyListener(this);
        ic.addKeyListener(this);
        for (i = 0; i < this.i5d.getNChannels(); ++i) {
            this.channelCanvasses.get(i).addKeyListener(this);
        }
        this.scrollbarsWL[3].addKeyListener(this);
        this.scrollbarsWL[4].addKeyListener(this);
        ij.addKeyListener((KeyListener)this);
        int nIJComponents = ij.getComponentCount();
        for (int i3 = 0; i3 < nIJComponents; ++i3) {
            ij.getComponent(i3).addKeyListener(this);
        }
        ij.getProgressBar().addKeyListener((KeyListener)this);
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.running2) {
            for (int i = 3; i < this.nDimensions; ++i) {
                if (e.getSource() != this.scrollbarsWL[i]) continue;
                this.positions[i] = this.scrollbarsWL[i].getValue();
            }
            this.notify();
        }
    }

    public void setDisplayMode(int displayMode) {
        if (this.displayMode == displayMode) {
            return;
        }
        if (displayMode == 3 && this.displayMode != 3) {
            for (int i = 0; i < this.i5d.getNChannels(); ++i) {
                this.add((Component)((Object)this.channelCanvasses.get(i)), "main");
            }
        } else if (displayMode != 3 && this.displayMode == 3) {
            for (int i = 0; i < this.i5d.getNChannels(); ++i) {
                this.remove((Component)((Object)this.channelCanvasses.get(i)));
            }
        }
        if (this.channelControl != null) {
            this.channelControl.setDisplayMode(displayMode);
        }
        this.displayMode = displayMode;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayGrayInTiles(boolean displayGrayInTiles) {
        if (this.displayGrayInTiles == displayGrayInTiles) {
            return;
        }
        if (this.channelControl != null) {
            this.channelControl.setDisplayGrayInTiles(displayGrayInTiles);
        }
        this.displayGrayInTiles = displayGrayInTiles;
    }

    public boolean isDisplayGrayInTiles() {
        return this.displayGrayInTiles;
    }

    public synchronized void channelChanged() {
        if (!this.running2) {
            this.positions[2] = this.channelControl.getCurrentChannel();
        }
        this.notify();
    }

    public void updateCanvasses() {
        int i;
        int oldN = this.channelCanvasses.size();
        if (this.displayMode == 3) {
            for (i = 0; i < oldN; ++i) {
                this.remove((Component)((Object)this.channelCanvasses.get(i)));
            }
        }
        this.channelCanvasses = new Vector();
        for (i = 1; i <= this.i5d.getNChannels(); ++i) {
            this.channelCanvasses.add(new Image5DCanvas(this.i5d.getChannelImagePlus(i)));
            this.i5d.getChannelImagePlus(i).setWindow((ImageWindow)this);
        }
        if (this.displayMode == 3) {
            for (i = 0; i < this.i5d.getNChannels(); ++i) {
                this.add((Component)((Object)this.channelCanvasses.get(i)), "main");
            }
        }
    }

    public void updateSliceSelector() {
        if (this.isInitialized) {
            int[] newDimensions = this.imp.getDimensions();
            if (newDimensions[2] > 1 && this.dimensions[2] <= 1 || newDimensions[2] <= 1 && this.dimensions[2] > 1) {
                this.channelControl.updateSelectorDisplay();
            }
            this.channelControl.setDisplayMode(this.i5d.getDisplayMode());
            this.channelControl.updateChannelSelector();
            if (newDimensions[3] > 1 && this.dimensions[3] <= 1) {
                this.add(this.scrollbarsWL[3], "slice");
            } else if (newDimensions[3] <= 1 && this.dimensions[3] > 1) {
                this.remove(this.scrollbarsWL[3]);
            }
            if (newDimensions[4] > 1 && this.dimensions[4] <= 1) {
                this.add(this.scrollbarsWL[4], "frame");
            } else if (newDimensions[4] <= 1 && this.dimensions[4] > 1) {
                this.remove(this.scrollbarsWL[4]);
            }
            this.dimensions = newDimensions;
            for (int i = 3; i < this.nDimensions; ++i) {
                int max = this.scrollbarsWL[i].getMaximum();
                if (max != this.dimensions[i] + 1) {
                    this.scrollbarsWL[i].setMaximum(this.dimensions[i] + 1);
                    int blockIncrement = this.dimensions[i] / 10;
                    if (blockIncrement < 1) {
                        blockIncrement = 1;
                    }
                    this.scrollbarsWL[i].setBlockIncrement(blockIncrement);
                }
                this.scrollbarsWL[i].setValue(((Image5D)this.imp).getCurrentPosition(i) + 1);
            }
        }
    }

    public String createSubtitle() {
        String s = "";
        Image5D img5 = (Image5D)this.imp;
        int[] dimensions = this.imp.getDimensions();
        Calibration cal = img5.getCalibration();
        ImageStack imageStack = img5.getImageStack();
        for (int i = 2; i < img5.getNDimensions(); ++i) {
            s = s + img5.getDimensionLabel(i).trim() + ":";
            s = s + (img5.getCurrentPosition(i) + 1);
            s = s + "/";
            s = s + dimensions[i];
            s = s + "; ";
        }
        String label = imageStack.getShortSliceLabel(img5.getCurrentImageStackIndex());
        if (label != null && label.length() > 0) {
            s = s + "(" + label + "); ";
        }
        if (this.running2) {
            return s;
        }
        s = cal.pixelWidth != 1.0 || cal.pixelHeight != 1.0 ? s + IJ.d2s((double)((double)this.imp.getWidth() * cal.pixelWidth), (int)2) + "x" + IJ.d2s((double)((double)this.imp.getHeight() * cal.pixelHeight), (int)2) + " " + cal.getUnits() + " (" + this.imp.getWidth() + "x" + this.imp.getHeight() + "); " : s + this.imp.getWidth() + "x" + this.imp.getHeight() + " pixels; ";
        int size = 1;
        for (int i = 0; i < img5.getNDimensions(); ++i) {
            size *= dimensions[i];
        }
        size /= 1024;
        int type = this.imp.getType();
        switch (type) {
            case 0: {
                s = s + "8-bit";
                break;
            }
            case 1: {
                s = s + "16-bit";
                size *= 2;
                break;
            }
            case 2: {
                s = s + "32-bit";
                size *= 4;
            }
        }
        if (this.imp.isInvertedLut()) {
            s = s + " (inverting LUT)";
        }
        if (size >= 10000) {
            s = s + "; " + (int)Math.round((double)size / 1024.0) + "MB";
        } else if (size >= 1024) {
            double size2 = (double)size / 1024.0;
            s = s + "; " + IJ.d2s((double)size2, (int)((double)((int)size2) == size2 ? 0 : 1)) + "MB";
        } else {
            s = s + "; " + size + "K";
        }
        return s;
    }

    public void paint(Graphics g) {
        this.drawRectangles();
        g.setColor(Color.black);
        this.drawInfo(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.isInitialized) {
            return;
        }
        while (!this.done) {
            Image5DWindow image5DWindow = this;
            synchronized (image5DWindow) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.done) {
                return;
            }
            for (int i = 2; i < this.nDimensions; ++i) {
                if (this.positions[i] <= 0) continue;
                int p = this.positions[i];
                this.positions[i] = 0;
                if (p == this.i5d.getCurrentPosition(i) + 1) continue;
                this.i5d.setCurrentPosition(i, p - 1);
            }
        }
    }

    public ChannelControl getChannelControl() {
        return this.channelControl;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getID() == 401 && this.imp instanceof Image5D) {
            boolean shiftPressed;
            Image5D i5d = (Image5D)this.imp;
            int code = e.getKeyCode();
            boolean ctrlPressed = (e.getModifiers() & 2) != 0;
            boolean bl = shiftPressed = (e.getModifiers() & 1) != 0;
            if (i5d == WindowManager.getCurrentImage()) {
                if (code == 97 || code == 34 && shiftPressed) {
                    i5d.setFrame(i5d.getCurrentFrame() - 1);
                    e.setKeyCode(65535);
                } else if (code == 98 || code == 33 && shiftPressed) {
                    i5d.setFrame(i5d.getCurrentFrame() + 1);
                    e.setKeyCode(65535);
                } else if (code == 103 || code == 34 && ctrlPressed) {
                    i5d.setChannel(i5d.getCurrentChannel() - 1);
                    e.setKeyCode(65535);
                } else if (code == 104 || code == 33 && ctrlPressed) {
                    i5d.setChannel(i5d.getCurrentChannel() + 1);
                    e.setKeyCode(65535);
                } else if (code == 100 || code == 34 || code == 153 || code == 44) {
                    i5d.setSlice(i5d.getCurrentSlice() - 1);
                    e.setKeyCode(65535);
                } else if (code == 101 || code == 33 || code == 160 || code == 46) {
                    i5d.setSlice(i5d.getCurrentSlice() + 1);
                    e.setKeyCode(65535);
                } else if (code == 37 || code == 39 || code == 38 || code == 40 || i5d.getRoi() instanceof TextRoi) {
                    this.adaptRois((Image5DCanvas)this.getCanvas());
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (event.isControlDown()) {
            Image5DWindow image5DWindow = this;
            synchronized (image5DWindow) {
                int channel = this.i5d.getCurrentChannel() + event.getWheelRotation();
                if (channel < 1) {
                    channel = 1;
                } else if (channel > this.i5d.getNChannels()) {
                    channel = this.i5d.getNChannels();
                }
                this.i5d.setChannel(channel);
            }
        } else if (event.isShiftDown()) {
            Image5DWindow image5DWindow = this;
            synchronized (image5DWindow) {
                int frame = this.i5d.getCurrentFrame() + event.getWheelRotation();
                if (frame < 1) {
                    frame = 1;
                } else if (frame > this.i5d.getNFrames()) {
                    frame = this.i5d.getNFrames();
                }
                this.i5d.setFrame(frame);
            }
        } else {
            super.mouseWheelMoved(event);
        }
    }

    public void setImagesUpdated() {
        this.ic.setImageUpdated();
        if (this.channelCanvasses == null) {
            return;
        }
        for (int i = 0; i < this.channelCanvasses.size(); ++i) {
            this.channelCanvasses.get(i).setImageUpdated();
        }
    }

    public void repaintCanvasses() {
        this.ic.repaint();
        if (this.channelCanvasses == null) {
            return;
        }
        for (int i = 0; i < this.channelCanvasses.size(); ++i) {
            this.channelCanvasses.get(i).repaint();
        }
    }

    public void adaptCanvasses(Image5DCanvas i5dc) {
        Dimension drawingSize = i5dc.getDrawingSize();
        Rectangle srcRect = i5dc.getSrcRect();
        double mag = i5dc.getMagnification();
        if (this.ic != i5dc) {
            Image5DCanvas tmpCanvas = (Image5DCanvas)this.ic;
            tmpCanvas.setSrcRectI5d((Rectangle)srcRect.clone());
            tmpCanvas.setMagnification(mag);
            tmpCanvas.setDrawingSize(drawingSize.width, drawingSize.height);
            tmpCanvas.repaint();
        }
        if (this.channelCanvasses == null) {
            return;
        }
        for (int i = 0; i < this.channelCanvasses.size(); ++i) {
            Image5DCanvas tmpCanvas = this.channelCanvasses.get(i);
            if (tmpCanvas == i5dc) continue;
            tmpCanvas.setSrcRectI5d((Rectangle)srcRect.clone());
            tmpCanvas.setMagnification(mag);
            tmpCanvas.setDrawingSize(drawingSize.width, drawingSize.height);
            tmpCanvas.repaint();
        }
    }

    public void adaptRois(Image5DCanvas i5dc) {
        Roi roi;
        int iCanvas = this.getCanvasChannelNumber(i5dc);
        if (iCanvas < 0) {
            return;
        }
        ImagePlus imp = i5dc.getImage();
        Roi tmpRoi = roi = imp.getRoi();
        if (iCanvas != 0) {
            if (roi != null && roi.isVisible() && roi.getPasteMode() == -1) {
                tmpRoi = (Roi)roi.clone();
            }
            Image5DCanvas tmpCanvas = (Image5DCanvas)this.ic;
            ((Image5D)tmpCanvas.getImage()).putRoi(tmpRoi);
            tmpCanvas.repaint();
        }
        if (this.channelCanvasses == null) {
            return;
        }
        for (int i = 0; i < this.channelCanvasses.size(); ++i) {
            if (iCanvas == i + 1) continue;
            tmpRoi = roi;
            if (roi != null && roi.isVisible() && (iCanvas != 0 || roi.getPasteMode() == -1 || this.i5d.getCurrentChannel() != i + 1)) {
                tmpRoi = (Roi)roi.clone();
            }
            Image5DCanvas tmpCanvas = this.channelCanvasses.get(i);
            ((ChannelImagePlus)tmpCanvas.getImage()).putRoi(tmpRoi);
            tmpCanvas.repaint();
        }
    }

    public void adaptMouse(Image5DCanvas i5dc) {
        Point cursorLoc = i5dc.getCursorLoc();
        int flags = i5dc.getModifiers();
        if (this.ic != i5dc) {
            Image5DCanvas tmpCanvas = (Image5DCanvas)this.ic;
            tmpCanvas.setCursorLoc(cursorLoc.x, cursorLoc.y);
            tmpCanvas.setModifiers(flags);
        }
        if (this.channelCanvasses == null) {
            return;
        }
        for (int i = 0; i < this.channelCanvasses.size(); ++i) {
            Image5DCanvas tmpCanvas = this.channelCanvasses.get(i);
            if (tmpCanvas == i5dc) continue;
            tmpCanvas.setCursorLoc(cursorLoc.x, cursorLoc.y);
            tmpCanvas.setModifiers(flags);
        }
    }

    public int getCanvasChannelNumber(Image5DCanvas i5dc) {
        if (i5dc == this.ic) {
            return 0;
        }
        for (int i = 0; i < this.channelCanvasses.size(); ++i) {
            if (this.channelCanvasses.get(i) != i5dc) continue;
            return i + 1;
        }
        return -1;
    }

    public void setChannelAsCurrent(Image5DCanvas i5dc) {
        int i = this.getCanvasChannelNumber(i5dc);
        if (i >= 1 && i != this.i5d.getCurrentChannel()) {
            this.i5d.setChannel(i);
        }
    }

    protected Rectangle getMaxWindowI5d() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle maxWindow = ge.getMaximumWindowBounds();
        Dimension ijSize = this.ij != null ? this.ij.getSize() : new Dimension(0, 0);
        maxWindow.y += ijSize.height;
        maxWindow.height -= ijSize.height;
        return maxWindow;
    }

    protected void drawRectangles() {
        Graphics g = this.getGraphics();
        LayoutManager layout = this.getLayout();
        if (layout != null && layout instanceof Image5DLayout) {
            Rectangle cBounds;
            Image5DLayout i5dLayout = (Image5DLayout)layout;
            g.setColor(Color.white);
            Rectangle coBounds = i5dLayout.getContentBounds();
            if (coBounds != null) {
                g.fillRect(coBounds.x, coBounds.y, coBounds.width, coBounds.height);
            }
            if ((cBounds = i5dLayout.getCanvasBounds(0)) != null) {
                g.setColor(Color.black);
                g.drawRect(cBounds.x - 1, cBounds.y - 1, cBounds.width + 1, cBounds.height + 1);
            }
            if (this.displayMode == 3) {
                for (int i = 1; i < i5dLayout.getNCanvasses(); ++i) {
                    Rectangle caBounds = i5dLayout.getCanvasBounds(i);
                    if (caBounds != null && i != this.i5d.getCurrentChannel()) {
                        g.setColor(Color.black);
                        g.drawRect(caBounds.x - 1, caBounds.y - 1, caBounds.width + 1, caBounds.height + 1);
                        continue;
                    }
                    if (caBounds == null) continue;
                    g.setColor(Color.red);
                    g.drawRect(caBounds.x - 1, caBounds.y - 1, caBounds.width + 1, caBounds.height + 1);
                    g.drawRect(caBounds.x - 2, caBounds.y - 2, caBounds.width + 3, caBounds.height + 3);
                    g.drawRect(caBounds.x - 3, caBounds.y - 3, caBounds.width + 5, caBounds.height + 5);
                }
            }
        }
    }
}

