/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageConverter;
import java.awt.Graphics;
import sc.fiji.i5d.Image5D;

public class Image5D_Stack_to_RGB
implements PlugIn {
    public void run(String arg) {
        ImagePlus currentImage = WindowManager.getCurrentImage();
        if (currentImage == null) {
            IJ.noImage();
            return;
        }
        if (!(currentImage instanceof Image5D)) {
            IJ.error((String)"Image is not an Image5D.");
            return;
        }
        String title = currentImage.getTitle();
        int width = currentImage.getWidth();
        int height = currentImage.getHeight();
        int depth = currentImage.getNSlices();
        int currentSlice = currentImage.getCurrentSlice();
        Calibration cal = currentImage.getCalibration().copy();
        currentImage.killRoi();
        ImagePlus rgbImage = IJ.createImage((String)(title + "-RGB"), (String)"RGB black", (int)width, (int)height, (int)1);
        ImageStack rgbStack = rgbImage.getStack();
        ImageCanvas canvas = currentImage.getCanvas();
        Graphics imageGfx = canvas.getGraphics();
        for (int i = 1; i <= depth; ++i) {
            currentImage.setSlice(i);
            if (currentImage instanceof Image5D) {
                ((Image5D)currentImage).updateImageAndDraw();
            }
            currentImage.updateAndDraw();
            canvas.paint(imageGfx);
            currentImage.copy(false);
            ImagePlus rgbClip = ImagePlus.getClipboard();
            if (rgbClip.getType() != 4) {
                new ImageConverter(rgbClip).convertToRGB();
            }
            if (i > 1) {
                rgbStack.addSlice(currentImage.getStack().getSliceLabel(i), rgbClip.getProcessor().getPixels());
                continue;
            }
            rgbStack.setPixels(rgbClip.getProcessor().getPixels(), 1);
            rgbStack.setSliceLabel(currentImage.getStack().getSliceLabel(1), 1);
        }
        imageGfx.dispose();
        currentImage.setSlice(currentSlice);
        rgbImage.setStack(null, rgbStack);
        rgbImage.setSlice(currentSlice);
        rgbImage.setCalibration(cal);
        rgbImage.killRoi();
        rgbImage.show();
    }
}

