/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.pivanalyser;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.FHT;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicInteger;
import org.scijava.util.VersionUtils;

public class PIV_analyser
implements PlugInFilter {
    private ImagePlus imp;
    private PairingParam pairs_param;
    private int[][] image_pairs;
    private int winsize_x = 16;
    private int winsize_y = 16;
    private boolean do_interpolation = true;
    private boolean do_masking = false;
    private double mask_value = 0.5;
    private static final String VERSION_STR = VersionUtils.getVersion(PIV_analyser.class);
    private static final String PLUGIN_NAME = "PIV analyser";
    private static final int COLOR_CIRCLE_SIZE = 128;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        this.pairs_param = new PairingParam();
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        return 2253;
    }

    public void run(ImageProcessor ip) {
        ImageStack stack = this.imp.getStack();
        int nslices = stack.getSize();
        if (nslices < 2) {
            IJ.error((String)"PIV_analysis requires at least two frames in the stack.");
        }
        String current = this.imp.getTitle();
        GenericDialog gd = new GenericDialog("PIV analyser v" + VERSION_STR);
        gd.addMessage(current);
        gd.addChoice("Window size (px)", WINDOW_SIZE.STR, WINDOW_SIZE.STR[3]);
        gd.addCheckbox("Diplay color wheel", true);
        gd.addMessage("Sub-pixel accuracy:");
        gd.addCheckbox("Interpolate", false);
        gd.addMessage("Masking with correlation peak:");
        gd.addCheckbox("Do masking", false);
        gd.addNumericField("Masking level", 0.5, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.winsize_y = this.winsize_x = WINDOW_SIZE.WS[gd.getNextChoiceIndex()];
        if (gd.getNextBoolean()) {
            PIV_analyser.displayColorCircle(this.winsize_x);
        }
        this.do_interpolation = gd.getNextBoolean();
        this.do_masking = gd.getNextBoolean();
        this.mask_value = gd.getNextNumber();
        this.pairs_param.first = 1;
        this.pairs_param.last = nslices;
        this.pairs_param.step = 1;
        this.pairs_param.jump = 1;
        this.setImagePairs(this.buildImagePairs());
        this.exec(true);
    }

    public final ImagePlus[] exec(final boolean show_calculation) {
        final ImageStack stack = this.imp.getStack();
        final int npairs = this.getImagePairs().length;
        final int image_width = stack.getWidth();
        final int image_height = stack.getHeight();
        final ImageStack u_st = new ImageStack(image_width, image_height, npairs);
        final ImageStack v_st = new ImageStack(image_width, image_height, npairs);
        final ImageStack pkh_st = new ImageStack(image_width, image_height, npairs);
        final ImageStack color_st = new ImageStack(image_width, image_height, npairs);
        final ImagePlus u_imp = this.imp.createImagePlus();
        final ImagePlus v_imp = this.imp.createImagePlus();
        final ImagePlus pkh_imp = this.imp.createImagePlus();
        final ImagePlus color_imp = this.imp.createImagePlus();
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = this.newThreadArray();
        final Roi roi = this.imp.getRoi() == null ? null : (Roi)this.imp.getRoi().clone();
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){
                int front_image;
                int back_image;
                FHT fft_front;
                FHT fft_back;
                FHT pcm;
                PIVresult piv;
                FloatProcessor front_block_imp;
                FloatProcessor back_block_imp;
                FloatProcessor back_imp;
                FloatProcessor front_imp;
                ColorProcessor color_ip;
                float[][] u;
                float[][] v;
                float[][] pkh;
                int[][] color_angle;
                {
                    this.u = new float[image_width][image_height];
                    this.v = new float[image_width][image_height];
                    this.pkh = new float[image_width][image_height];
                    this.color_angle = new int[image_width][image_height];
                }

                @Override
                public void run() {
                    int i = ai.getAndIncrement();
                    while (i < npairs) {
                        int y;
                        int x;
                        this.back_image = PIV_analyser.this.getImagePairs()[i][0];
                        this.front_image = PIV_analyser.this.getImagePairs()[i][1];
                        this.back_imp = (FloatProcessor)stack.getProcessor(this.back_image).convertToFloat();
                        this.front_imp = (FloatProcessor)stack.getProcessor(this.front_image).convertToFloat();
                        if (IJ.escapePressed()) {
                            IJ.showStatus((String)"PIV analysis cancelled.");
                            break;
                        }
                        for (x = 0; x <= image_width - PIV_analyser.this.winsize_x; ++x) {
                            for (y = 0; y <= image_height - PIV_analyser.this.winsize_y; ++y) {
                                if (roi != null && !roi.contains(x + PIV_analyser.this.winsize_x / 2, y + PIV_analyser.this.winsize_y / 2)) continue;
                                this.front_imp.setRoi(x, y, PIV_analyser.this.winsize_x, PIV_analyser.this.winsize_y);
                                this.front_block_imp = (FloatProcessor)this.front_imp.crop();
                                this.back_imp.setRoi(x, y, PIV_analyser.this.winsize_x, PIV_analyser.this.winsize_y);
                                this.back_block_imp = (FloatProcessor)this.back_imp.crop();
                                PIV_analyser.substractMean(this.back_block_imp);
                                PIV_analyser.substractMean(this.front_block_imp);
                                this.fft_front = new FHT((ImageProcessor)this.front_block_imp);
                                this.fft_front.setShowProgress(false);
                                this.fft_back = new FHT((ImageProcessor)this.back_block_imp);
                                this.fft_back.setShowProgress(false);
                                this.fft_front.transform();
                                this.fft_back.transform();
                                this.pcm = this.fft_front.conjugateMultiply(this.fft_back);
                                this.pcm.setShowProgress(false);
                                this.pcm.inverseTransform();
                                this.pcm.swapQuadrants();
                                this.piv = PIV_analyser.this.findMax(this.pcm, PIV_analyser.this.do_interpolation);
                                this.u[x + ((PIV_analyser)PIV_analyser.this).winsize_x / 2][y + ((PIV_analyser)PIV_analyser.this).winsize_y / 2] = this.piv.max_x_interpolated;
                                this.v[x + ((PIV_analyser)PIV_analyser.this).winsize_x / 2][y + ((PIV_analyser)PIV_analyser.this).winsize_y / 2] = this.piv.max_y_interpolated;
                                this.pkh[x + ((PIV_analyser)PIV_analyser.this).winsize_x / 2][y + ((PIV_analyser)PIV_analyser.this).winsize_y / 2] = this.piv.peak_height;
                            }
                        }
                        if (PIV_analyser.this.do_masking) {
                            float max_pkh = PIV_analyser.getMax(this.pkh);
                            PIV_analyser.this.mask(this.u, this.pkh, max_pkh);
                            PIV_analyser.this.mask(this.v, this.pkh, max_pkh);
                        }
                        for (x = 0; x <= image_width - PIV_analyser.this.winsize_x; ++x) {
                            for (y = 0; y <= image_height - PIV_analyser.this.winsize_y; ++y) {
                                this.color_angle[x + ((PIV_analyser)PIV_analyser.this).winsize_x / 2][y + ((PIV_analyser)PIV_analyser.this).winsize_y / 2] = PIV_analyser.colorVector(this.u[x + PIV_analyser.this.winsize_x / 2][y + PIV_analyser.this.winsize_y / 2], this.v[x + PIV_analyser.this.winsize_x / 2][y + PIV_analyser.this.winsize_y / 2], PIV_analyser.this.winsize_x / 2);
                            }
                        }
                        u_st.setPixels(new FloatProcessor(this.u).getPixels(), i + 1);
                        v_st.setPixels(new FloatProcessor(this.v).getPixels(), i + 1);
                        pkh_st.setPixels(new FloatProcessor(this.pkh).getPixels(), i + 1);
                        this.color_ip = new ColorProcessor(image_width, image_height);
                        this.color_ip.setIntArray(this.color_angle);
                        color_st.setPixels(this.color_ip.getPixels(), i + 1);
                        if (i == 0) {
                            u_imp.setStack("U", u_st);
                            v_imp.setStack("V", v_st);
                            pkh_imp.setStack("Peak height", pkh_st);
                            color_imp.setStack("Flow direction", color_st);
                            if (show_calculation) {
                                u_imp.show();
                                v_imp.show();
                                pkh_imp.show();
                                color_imp.show();
                            }
                        }
                        IJ.showProgress((int)i, (int)npairs);
                        i = ai.getAndIncrement();
                    }
                }
            };
        }
        PIV_analyser.startAndJoin(threads);
        if (show_calculation) {
            ImageCanvas color_canvas = color_imp.getCanvas();
            color_canvas.addMouseMotionListener(PIV_analyser.getColorMouseListener((float)this.winsize_x / 2.0f));
        }
        return new ImagePlus[]{u_imp, v_imp, pkh_imp, color_imp};
    }

    public final PIVresult findMax(FHT pcm, boolean interpolate) {
        PIVresult piv = new PIVresult();
        float[] pixels = (float[])pcm.getPixels();
        float pkh = -3.4028235E38f;
        int loc = 0;
        for (int i = 0; i < pixels.length; ++i) {
            float val = pixels[i];
            if (!(val > pkh)) continue;
            pkh = val;
            loc = i;
        }
        piv.peak_height = pkh;
        piv.max_x = loc % this.winsize_x - this.winsize_x / 2;
        piv.max_y = loc / this.winsize_x - this.winsize_y / 2;
        if (interpolate) {
            try {
                float e00 = pixels[loc - this.winsize_x - 1];
                float e10 = pixels[loc - this.winsize_x];
                float e20 = pixels[loc - this.winsize_x + 1];
                float e01 = pixels[loc - 1];
                float e11 = pixels[loc];
                float e21 = pixels[loc + 1];
                float e02 = pixels[loc + this.winsize_x - 1];
                float e12 = pixels[loc + this.winsize_x];
                float e22 = pixels[loc + this.winsize_x + 1];
                float dx = (e21 - e01) / 2.0f;
                float dy = (e12 - e10) / 2.0f;
                float e11_2 = 2.0f * e11;
                float dxx = e01 - e11_2 + e21;
                float dyy = e10 - e11_2 + e12;
                float dxy = (e22 - e02 - e20 + e00) / 4.0f;
                float det = dxx * dyy - dxy * dxy;
                if (det == 0.0f) {
                    piv.max_x_interpolated = piv.max_x;
                    piv.max_y_interpolated = piv.max_y;
                }
                float ox = dyy / det * dx - dxy / det * dy;
                float oy = -dxy / det * dx + dxx / det * dy;
                piv.max_x_interpolated = (float)piv.max_x - 3.0f * ox;
                piv.max_y_interpolated = (float)piv.max_y - 3.0f * oy;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                piv.max_x_interpolated = piv.max_x;
                piv.max_y_interpolated = piv.max_y;
            }
        } else {
            piv.max_x_interpolated = piv.max_x;
            piv.max_y_interpolated = piv.max_y;
        }
        return piv;
    }

    void showAbout() {
        IJ.showMessage((String)"About PIV_analysis...", (String)" <h3>PIV analysis</h3> \n This plugin calculates the optic flow for each pair of images made with the\n given stack. It does using the PIV method, which is the most basic technique\n for optic flow, and is a block-based method. This a technique, mainly used in\n acoustics or in fluids mechanics, that enables the measurements of a velocity\n field in one plane, using imaging and image analysis. It can be seen as one\n of the most simple pattern matching problem implementation.\n \n  PIV analysis is based on inferring in what direction and in what amount a\n  part of an image has moved between two successive instant. In the\n  aforementioned domains, a flow is visualized by seeding it with\n  light-reflecting particle (smoke in air, bubbles, glass beads in water, ...)\n  and imaged at two very close instant. The cross-correlation between parts of\n  the two images where pattern generated by particles can be seen is then used\n  to compute the velocity field.\n  \n  The PIV algorithm is made of the following steps:\n  <ol>\n  <li>two images are acquired of the same object are acquired at two successive\n  instant;\n  <li>they are spliced in small pieces called interrogation windows;\n  <li>the cross-correlation between the two images is computed for each small\n  window;\n  <li>the peak in the resulting correlation image is searched for. The peak\n  location gives the displacement for which the two image parts look the best\n  alike, that is: the amount by which the second image has to be moved to look\n  like the first image the best;\n  <li>the velocity vector at this point is defined as the peak's position. This\n  assume that between the two successive instants, the image did not change too\n  much in content, but moved or deformed.\n  </ol>\n ");
    }

    protected static final int colorVector(float xs, float ys, float maxDistance) {
        double a;
        if ((a = Math.sqrt((xs /= maxDistance) * xs + (ys /= maxDistance) * ys)) == 0.0) {
            return 0;
        }
        double o = (Math.atan2((double)xs / a, (double)ys / a) + Math.PI) / Math.PI * 3.0;
        double r = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        if ((o += 2.0) >= 6.0) {
            o -= 6.0;
        }
        double g = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        if ((o += 2.0) >= 6.0) {
            o -= 6.0;
        }
        double b = o < 3.0 ? Math.min(1.0, Math.max(0.0, 2.0 - o)) * a : Math.min(1.0, Math.max(0.0, o - 4.0)) * a;
        return (((int)(r * 255.0) << 8) + (int)(g * 255.0) << 8) + (int)(b * 255.0);
    }

    public static final void colorCircle(ColorProcessor ip) {
        int lx = ip.getWidth();
        int ly = ip.getHeight();
        int r1 = Math.min(lx, ly) / 2;
        for (int y = 0; y < ly; ++y) {
            float dy = y - ly / 2;
            for (int x = 0; x < lx; ++x) {
                float dx = x - lx / 2;
                float l = (float)Math.sqrt(dx * dx + dy * dy);
                if (l > (float)r1) {
                    ip.putPixel(x, y, 0);
                    continue;
                }
                ip.putPixel(x, y, PIV_analyser.colorVector(dx, dy, r1));
            }
        }
    }

    public static final void displayColorCircle(final float maxDisplacement) {
        ColorProcessor cp = new ColorProcessor(128, 128);
        PIV_analyser.colorCircle(cp);
        ImagePlus cwimp = new ImagePlus("Color coded orientation", (ImageProcessor)cp);
        cwimp.show();
        final ImageCanvas cwcanvas = cwimp.getCanvas();
        cwcanvas.addMouseMotionListener(new MouseMotionListener(){
            private final int xc = 64;
            private final int yc = 64;

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Point coord = cwcanvas.getCursorLoc();
                int x = coord.x;
                int y = coord.y;
                int dx = x - 64;
                int dy = y - 64;
                double v = Math.sqrt(dx * dx + dy * dy) / 128.0 * (double)maxDisplacement;
                double alpha = -Math.toDegrees(Math.atan2(dy, dx));
                IJ.showStatus((String)String.format("Velocity: %5.1f px/frame - Direction %3.0f\u00ba", v, alpha));
            }
        });
    }

    private Thread[] newThreadArray() {
        int n_cpus = Runtime.getRuntime().availableProcessors();
        return new Thread[n_cpus];
    }

    public static void startAndJoin(Thread[] threads) {
        int ithread;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread].setPriority(5);
            threads[ithread].setName("PIV analyser thread nbr " + ithread);
            threads[ithread].start();
        }
        try {
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread].join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private static final MouseMotionListener getColorMouseListener(final float maxVel) {
        return new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                double magnitude;
                double alpha;
                ImageCanvas source = (ImageCanvas)e.getComponent();
                Point coord = source.getCursorLoc();
                BufferedImage im = (BufferedImage)((ImageWindow)source.getParent()).getImagePlus().getImage();
                int cp = im.getRGB(coord.x, coord.y);
                float r = cp >> 16 & 0xFF;
                float g = cp >> 8 & 0xFF;
                float b = cp & 0xFF;
                if (b == 0.0f) {
                    if (r > g) {
                        alpha = 1.0471975511965976 * (double)g / (double)r;
                        magnitude = r / 255.0f * maxVel;
                    } else {
                        alpha = 2.0943951023931953 * (1.0 - 0.5 * (double)r / (double)g);
                        magnitude = g / 255.0f * maxVel;
                    }
                } else if (r == 0.0f) {
                    if (g > b) {
                        alpha = 2.0943951023931953 * (1.0 + 0.5 * (double)b / (double)g);
                        magnitude = g / 255.0f * maxVel;
                    } else {
                        alpha = 2.0943951023931953 * (2.0 - 0.5 * (double)g / (double)b);
                        magnitude = b / 255.0f * maxVel;
                    }
                } else if (b > r) {
                    alpha = 2.0943951023931953 * (2.0 + 0.5 * (double)r / (double)b);
                    magnitude = b / 255.0f * maxVel;
                } else {
                    alpha = 2.0943951023931953 * (3.0 - 0.5 * (double)b / (double)r);
                    magnitude = r / 255.0f * maxVel;
                }
                alpha = -(alpha - 1.5707963267948966);
                if (alpha < -Math.PI) {
                    alpha += Math.PI * 2;
                }
                IJ.showStatus((String)String.format("Velocity: %5.1f px/frame - Direction %3.0f\u00ba", magnitude, Math.toDegrees(alpha)));
            }
        };
    }

    private final void mask(float[][] arr, float[][] mask_arr, float max_mask_value) {
        float val = (float)(this.mask_value * (double)max_mask_value);
        for (int i = 0; i < mask_arr.length; ++i) {
            for (int j = 0; j < mask_arr[i].length; ++j) {
                if (!(mask_arr[i][j] < val)) continue;
                arr[i][j] = 0.0f;
            }
        }
    }

    public static final float getMax(float[][] arr) {
        float max = -3.4028235E38f;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                if (!(arr[i][j] > max)) continue;
                max = arr[i][j];
            }
        }
        return max;
    }

    private static void substractMean(FloatProcessor fp) {
        float[] pixels = (float[])fp.getPixels();
        float sum = pixels[0];
        for (int i = 1; i < pixels.length; ++i) {
            sum += pixels[i];
        }
        float mean = sum / (float)pixels.length;
        int i = 0;
        while (i < pixels.length) {
            int n = i++;
            pixels[n] = pixels[n] - mean;
        }
    }

    private int[][] buildImagePairs() {
        return PIV_analyser.buildImagePairs(this.pairs_param);
    }

    private static int[][] buildImagePairs(int first, int last, int step, int jump) {
        int npairs = (int)Math.ceil((last - (first + jump - 1)) / step);
        int[][] pairs = new int[npairs][2];
        for (int index = 0; index < npairs; ++index) {
            int back = first + index * step;
            int front = back + jump;
            pairs[index][0] = back;
            pairs[index][1] = front;
        }
        return pairs;
    }

    private static int[][] buildImagePairs(PairingParam param) {
        int first = param.first;
        int last = param.last;
        int step = param.step;
        int jump = param.jump;
        return PIV_analyser.buildImagePairs(first, last, step, jump);
    }

    public void setImagePairs(int[][] image_pairs) {
        this.image_pairs = image_pairs;
    }

    public int[][] getImagePairs() {
        return this.image_pairs;
    }

    public void setWinsize(WINDOW_SIZE ws) {
        this.winsize_x = ws.toInt();
        this.winsize_y = ws.toInt();
    }

    public int[] getWinsize() {
        return new int[]{this.winsize_x, this.winsize_y};
    }

    public void setInterpolation(boolean doit) {
        this.do_interpolation = doit;
    }

    public boolean getInterpolation() {
        return this.do_interpolation;
    }

    protected class PIVresult {
        int max_x;
        int max_y;
        float max_x_interpolated;
        float max_y_interpolated;
        float peak_height;
        float snr;

        protected PIVresult() {
        }
    }

    protected class PairingParam {
        int first;
        int last;
        int step;
        int jump;

        protected PairingParam() {
        }
    }

    public static enum WINDOW_SIZE {
        _4x4,
        _8x8,
        _16x16,
        _32x32,
        _64x64,
        _128x128;

        private static final int[] WS;
        private static final String[] STR;

        public int toInt() {
            return WS[this.ordinal()];
        }

        static {
            WS = new int[]{4, 8, 16, 32, 64, 128};
            STR = new String[]{"4x4", "8x8", "16x16", "32x32", "64x64", "128x128"};
        }
    }
}

