/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.network.client;

import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.compute.ProcessManager;
import edu.utexas.clm.archipelago.data.ClusterMessage;
import edu.utexas.clm.archipelago.data.Duplex;
import edu.utexas.clm.archipelago.data.HeartBeat;
import edu.utexas.clm.archipelago.listen.MessageType;
import edu.utexas.clm.archipelago.listen.TransceiverExceptionListener;
import edu.utexas.clm.archipelago.listen.TransceiverListener;
import edu.utexas.clm.archipelago.network.MessageXC;
import edu.utexas.clm.archipelago.network.translation.Bottler;
import edu.utexas.clm.archipelago.network.translation.PathSubstitutingFileTranslator;
import edu.utexas.clm.archipelago.util.XCErrorAdapter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public class ArchipelagoClient
implements TransceiverListener {
    private static ArrayList<ArchipelagoClient> clients = new ArrayList();
    private final MessageXC xc;
    private long clientId = 0L;
    private final AtomicBoolean active;
    private final Vector<ProcessThread> runningThreads;
    private final HeartBeatThread beatThread;
    private final TransceiverExceptionListener xcEListener;
    public static String clientHost = "";

    public static ArrayList<ArchipelagoClient> getClients() {
        return new ArrayList<ArchipelagoClient>(clients);
    }

    public static ArchipelagoClient getFirstClient() {
        if (clients.isEmpty()) {
            return null;
        }
        return clients.get(0);
    }

    public ArchipelagoClient(long id, InputStream inStream, OutputStream outStream) throws IOException {
        this(id, inStream, outStream, new XCErrorAdapter(){

            @Override
            protected boolean handleCustomRX(Throwable t, MessageXC xc, ClusterMessage cm) {
                t.printStackTrace(System.out);
                if (t instanceof ClassCastException) {
                    this.reportRX(t, t.toString(), xc);
                    xc.queueMessage(MessageType.ERROR, t);
                    return false;
                }
                if (t instanceof EOFException) {
                    this.reportRX(t, "Received EOF", xc);
                    xc.close();
                    return false;
                }
                if (t instanceof StreamCorruptedException) {
                    this.reportRX(t, "Stream corrupted: " + t, xc);
                    return false;
                }
                xc.queueMessage(MessageType.ERROR, t);
                return true;
            }

            @Override
            protected boolean handleCustomTX(Throwable t, MessageXC xc, ClusterMessage cm) {
                xc.queueMessage(MessageType.ERROR, t);
                return true;
            }
        });
    }

    public ArchipelagoClient(long id, InputStream inStream, OutputStream outStream, TransceiverExceptionListener tel) throws IOException {
        FijiArchipelago.log("Starting Archipelago Client...");
        try {
            this.xcEListener = tel;
            this.clientId = id;
            this.xc = new MessageXC(inStream, outStream, this, this.xcEListener);
            this.xc.setId(id);
            this.beatThread = new HeartBeatThread(1000L, Runtime.getRuntime());
            this.runningThreads = new Vector();
            this.active = new AtomicBoolean(true);
        }
        catch (IOException ioe) {
            FijiArchipelago.log("Caught an IOE: " + ioe);
            throw ioe;
        }
        if (clientHost.equals("")) {
            try {
                clientHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                FijiArchipelago.log("Could not resolve local name: " + uhe);
                clientHost = "Unknown";
            }
        }
        clients.add(this);
        FijiArchipelago.log("Archipelago Client is Active");
    }

    @Override
    public void handleMessage(ClusterMessage cm) {
        MessageType type = cm.type;
        Serializable object = cm.o;
        FijiArchipelago.log("Got message " + ClusterMessage.messageToString(cm));
        try {
            switch (type) {
                case PROCESS: {
                    ProcessManager pm = (ProcessManager)object;
                    ProcessThread pt = new ProcessThread(pm);
                    this.runningThreads.add(pt);
                    pt.start();
                    break;
                }
                case HALT: {
                    this.close();
                    break;
                }
                case PING: {
                    this.xc.queueMessage(MessageType.PING);
                    break;
                }
                case USER: {
                    cm.o = System.getProperty("user.name");
                    this.xc.queueMessage(cm);
                    break;
                }
                case SETID: {
                    this.clientId = (Long)object;
                    this.xc.setId(this.clientId);
                    this.xc.queueMessage(MessageType.SETID);
                    break;
                }
                case GETID: {
                    this.xc.queueMessage(MessageType.GETID, Long.valueOf(this.clientId));
                    break;
                }
                case BOTTLER: {
                    this.xc.addBottler((Bottler)object);
                    break;
                }
                case SETEXECROOT: {
                    FijiArchipelago.setExecRoot((String)((Object)object));
                    this.xc.queueMessage(MessageType.SETEXECROOT);
                    break;
                }
                case GETFSTRANSLATION: {
                    this.xc.queueMessage(MessageType.GETFSTRANSLATION, (Serializable)((Object)FijiArchipelago.getFileRoot()));
                    break;
                }
                case GETEXECROOT: {
                    this.xc.queueMessage(MessageType.GETEXECROOT, (Serializable)((Object)FijiArchipelago.getExecRoot()));
                    break;
                }
                case CANCELJOB: {
                    long id = (Long)object;
                    for (ProcessThread processThread : this.runningThreads) {
                        if (processThread.getID() != id) continue;
                        processThread.cancel();
                        this.runningThreads.remove(processThread);
                        return;
                    }
                    break;
                }
                case HOSTNAME: {
                    this.xc.queueMessage(MessageType.HOSTNAME, (Serializable)((Object)clientHost));
                    break;
                }
                case NUMTHREADS: {
                    this.xc.queueMessage(MessageType.NUMTHREADS, Integer.valueOf(Runtime.getRuntime().availableProcessors()));
                    break;
                }
                case BEAT: {
                    if (this.beatThread.isAlive()) break;
                    this.beatThread.start();
                    break;
                }
                case SETFSTRANSLATION: {
                    Duplex translation = (Duplex)object;
                    this.xc.setFileSystemTranslator(new PathSubstitutingFileTranslator((String)translation.a, (String)translation.b));
                    this.xc.queueMessage(MessageType.SETFSTRANSLATION);
                }
            }
        }
        catch (ClassCastException cce) {
            this.xcEListener.handleRXThrowable(cce, this.xc, cm);
        }
    }

    public void log(String string) {
        this.xc.queueMessage(MessageType.LOG, (Serializable)((Object)string));
    }

    public boolean join() {
        return this.xc.join();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public synchronized void close() {
        if (this.active.get()) {
            Thread.dumpStack();
            FijiArchipelago.log("Closing Client");
            this.active.set(false);
            for (ProcessThread t : this.runningThreads) {
                t.cancel();
            }
            this.beatThread.interrupt();
            this.xc.close();
        }
    }

    @Override
    public synchronized void streamClosed() {
        FijiArchipelago.log("Lost socket connection");
        this.close();
    }

    private class ProcessThread
    extends Thread {
        private final ProcessManager process;
        private final AtomicBoolean running;

        public ProcessThread(ProcessManager pm) {
            this.process = pm;
            this.running = new AtomicBoolean(true);
        }

        public void cancel() {
            this.running.set(false);
            this.interrupt();
        }

        public long getID() {
            return this.process.getID();
        }

        @Override
        public void run() {
            long s = System.currentTimeMillis();
            FijiArchipelago.debug("Client: Running process " + this.process.getID());
            this.process.run();
            FijiArchipelago.debug("Client: Process " + this.process.getID() + " has finished. Took " + (System.currentTimeMillis() - s) + "ms");
            ArchipelagoClient.this.runningThreads.remove(this);
            if (this.running.get() && ArchipelagoClient.this.active.get()) {
                ArchipelagoClient.this.xc.queueMessage(MessageType.PROCESS, this.process);
            }
        }
    }

    private class HeartBeatThread
    extends Thread {
        private final long interval;
        private final Runtime runtime;

        public HeartBeatThread(long interval, Runtime runtime) {
            this.interval = interval;
            this.runtime = runtime;
        }

        @Override
        public void run() {
            while (ArchipelagoClient.this.active.get()) {
                try {
                    Thread.sleep(this.interval);
                    HeartBeat beat = new HeartBeat(this.runtime.freeMemory(), this.runtime.totalMemory(), this.runtime.maxMemory());
                    ArchipelagoClient.this.xc.queueMessage(MessageType.BEAT, beat);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

