/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.network.node;

import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.compute.ProcessManager;
import edu.utexas.clm.archipelago.data.ClusterMessage;
import edu.utexas.clm.archipelago.data.Duplex;
import edu.utexas.clm.archipelago.data.HeartBeat;
import edu.utexas.clm.archipelago.exception.ShellExecutionException;
import edu.utexas.clm.archipelago.listen.MessageType;
import edu.utexas.clm.archipelago.listen.NodeShellListener;
import edu.utexas.clm.archipelago.listen.NodeStateListener;
import edu.utexas.clm.archipelago.listen.ProcessListener;
import edu.utexas.clm.archipelago.listen.TransceiverExceptionListener;
import edu.utexas.clm.archipelago.listen.TransceiverListener;
import edu.utexas.clm.archipelago.network.MessageXC;
import edu.utexas.clm.archipelago.network.node.ClusterNodeState;
import edu.utexas.clm.archipelago.network.node.NodeParameters;
import edu.utexas.clm.archipelago.network.translation.Bottler;
import edu.utexas.clm.archipelago.network.translation.PathSubstitutingFileTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ClusterNode
implements TransceiverListener {
    private MessageXC xc = null;
    private final Hashtable<Long, ProcessListener> processHandlers;
    private final Hashtable<Long, ProcessManager> runningProcesses;
    private final AtomicInteger ramMBAvail;
    private final AtomicInteger ramMBTot;
    private final AtomicInteger ramMBMax;
    private final AtomicInteger runningCores;
    private long nodeID;
    private long lastBeatTime = 0L;
    private final NodeParameters nodeParam;
    private ClusterNodeState state = ClusterNodeState.INACTIVE;
    private final Vector<NodeStateListener> stateListeners;
    private final TransceiverExceptionListener xcEListener;
    private final AtomicBoolean environmentIsSynced;
    private final AtomicBoolean execRootSet;
    private final AtomicBoolean fileSystemSet;

    public ClusterNode(NodeParameters params, TransceiverExceptionListener tel) {
        this.ramMBAvail = new AtomicInteger(0);
        this.ramMBTot = new AtomicInteger(0);
        this.ramMBMax = new AtomicInteger(0);
        this.runningCores = new AtomicInteger(0);
        this.processHandlers = new Hashtable();
        this.runningProcesses = new Hashtable();
        this.nodeID = params.getID();
        this.nodeParam = params;
        this.stateListeners = new Vector();
        this.xcEListener = tel;
        this.environmentIsSynced = new AtomicBoolean(false);
        this.execRootSet = new AtomicBoolean(false);
        this.fileSystemSet = new AtomicBoolean(false);
    }

    private void checkState() {
        if (this.getID() >= 0L && this.getThreadLimit() > 0) {
            this.setState(ClusterNodeState.ACTIVE);
        }
    }

    private synchronized void doSyncEnvironment() {
        if (!this.environmentIsSynced.get()) {
            if (this.getUser() == null || this.getUser().equals("")) {
                this.xc.queueMessage(MessageType.USER);
                return;
            }
            if (this.getID() < 0L) {
                this.xc.queueMessage(MessageType.GETID);
                return;
            }
            if (!this.execRootSet.getAndSet(true)) {
                if (this.getExecPath() == null || this.getExecPath().equals("")) {
                    this.xc.queueMessage(MessageType.GETEXECROOT);
                    return;
                }
                this.xc.queueMessage(MessageType.SETEXECROOT, (Serializable)((Object)this.getExecPath()));
                return;
            }
            if (!this.fileSystemSet.getAndSet(true)) {
                if (this.getFilePath() == null || this.getFilePath().equals("")) {
                    this.xc.queueMessage(MessageType.GETFSTRANSLATION);
                    return;
                }
                this.xc.queueMessage(MessageType.SETFSTRANSLATION, new Duplex<String, String>(this.getFilePath(), FijiArchipelago.getFileRoot()));
            }
            if (this.getThreadLimit() <= 0) {
                this.xc.queueMessage(MessageType.NUMTHREADS);
                return;
            }
            this.xc.queueMessage(MessageType.BEAT);
            this.checkState();
            FijiArchipelago.debug("Environment is synced");
            this.environmentIsSynced.set(true);
        }
    }

    public void setExecPath(String path) {
        this.nodeParam.setExecRoot(path);
    }

    public void setFilePath(String path) {
        this.nodeParam.setFileRoot(path);
        this.xc.setFileSystemTranslator(new PathSubstitutingFileTranslator(FijiArchipelago.getFileRoot(), path));
    }

    @Override
    public void streamClosed() {
        FijiArchipelago.log("Stream closed on " + this.getHost());
        if (this.state != ClusterNodeState.STOPPED) {
            this.close();
        }
    }

    public synchronized void setIOStreams(InputStream is, OutputStream os) throws IOException, TimeoutException, InterruptedException {
        FijiArchipelago.debug("Setting IO Streams for a new Cluster Node");
        this.xc = new MessageXC(is, os, this, this.xcEListener);
        this.xc.queueMessage(MessageType.GETID);
        this.doSyncEnvironment();
        this.xc.setHostname(this.getHost());
    }

    public synchronized void setMessageXC(MessageXC xc) {
        this.xc = xc;
        xc.setListener(this);
        this.doSyncEnvironment();
        xc.setHostname(this.getHost());
    }

    public String getHost() {
        return this.nodeParam.getHost();
    }

    public String getUser() {
        return this.nodeParam.getUser();
    }

    public String getExecPath() {
        return this.nodeParam.getExecRoot();
    }

    public String getFilePath() {
        return this.nodeParam.getFileRoot();
    }

    public boolean isReady() {
        return this.state == ClusterNodeState.ACTIVE;
    }

    public long getID() {
        return this.nodeID;
    }

    public NodeParameters getParam() {
        return this.nodeParam;
    }

    public int numRunningThreads() {
        return this.runningCores.get();
    }

    public int numAvailableThreads() {
        int n = this.nodeParam.getThreadLimit() - this.runningCores.get();
        return n > 0 ? n : 0;
    }

    public int getThreadLimit() {
        return this.nodeParam.getThreadLimit();
    }

    public void setActive(boolean active) {
        this.setState(active ? ClusterNodeState.ACTIVE : ClusterNodeState.INACTIVE);
    }

    public boolean submit(ProcessManager<?> process, ProcessListener listener) {
        FijiArchipelago.debug("ClusterNode: " + this.getHost() + " got submit for " + process.getID());
        if (this.isReady()) {
            if (this.processHandlers.get(process.getID()) == null) {
                if (this.xc.queueMessage(MessageType.PROCESS, process)) {
                    int nCore = process.requestedCores(this);
                    this.processHandlers.put(process.getID(), listener);
                    this.runningProcesses.put(process.getID(), process);
                    process.setRunningOn(this);
                    this.runningCores.addAndGet(nCore);
                    FijiArchipelago.debug("ClusterNode: Placing process " + process.getID() + " on xc queue");
                    return true;
                }
                FijiArchipelago.debug("ClusterNode: Process " + process.getID() + " rejected from queue");
                return false;
            }
            FijiArchipelago.debug("There is already a process " + process.getID() + " on " + this.getHost());
            return false;
        }
        FijiArchipelago.debug("ClusterNode: " + this.getHost() + " is not ready yet");
        return false;
    }

    public long lastBeat() {
        return this.lastBeatTime;
    }

    @Override
    public void handleMessage(ClusterMessage cm) {
        MessageType type = cm.type;
        Serializable object = cm.o;
        try {
            switch (type) {
                case GETID: {
                    Long id = (Long)object;
                    FijiArchipelago.debug("Got id message. Setting ID to " + id + ". Param: " + this.nodeParam);
                    if (id >= 0L) {
                        this.nodeID = id;
                        this.xc.setId(this.nodeID);
                    }
                    this.doSyncEnvironment();
                    this.checkState();
                    break;
                }
                case BEAT: {
                    HeartBeat beat = (HeartBeat)object;
                    this.lastBeatTime = System.currentTimeMillis();
                    this.ramMBAvail.set(beat.ramMBAvailable);
                    this.ramMBTot.set(beat.ramMBTotal);
                    this.ramMBMax.set(beat.ramMBMax);
                    break;
                }
                case LOG: {
                    FijiArchipelago.debug(object.toString());
                    break;
                }
                case PROCESS: {
                    ProcessManager pm = (ProcessManager)object;
                    ProcessListener listener = this.processHandlers.remove(pm.getID());
                    FijiArchipelago.debug("ClusterNode: " + this.getHost() + " got result for " + pm.getID());
                    this.removeProcess(pm);
                    listener.processFinished(pm);
                    FijiArchipelago.debug("ClusterNode: " + this.getHost() + " listener returned for " + pm.getID());
                    break;
                }
                case NUMTHREADS: {
                    int n = (Integer)object;
                    this.nodeParam.setThreadLimit(n);
                    this.doSyncEnvironment();
                    this.checkState();
                    break;
                }
                case PING: {
                    FijiArchipelago.log("Received ping from " + this.getHost());
                    break;
                }
                case USER: {
                    if (object != null) {
                        String username = (String)((Object)object);
                        this.nodeParam.setUser(username);
                    } else {
                        FijiArchipelago.err("Got username message with null user");
                        this.nodeParam.setUser("unknown");
                    }
                    this.doSyncEnvironment();
                    break;
                }
                case GETFSTRANSLATION: {
                    String path = (String)((Object)object);
                    if (path.equals("")) {
                        this.xc.queueMessage(MessageType.SETFSTRANSLATION, new Duplex<String, String>(FijiArchipelago.getFileRoot(), FijiArchipelago.getFileRoot()));
                        break;
                    }
                    this.setFilePath(path);
                    this.xc.queueMessage(MessageType.SETFSTRANSLATION, new Duplex<String, String>(path, FijiArchipelago.getFileRoot()));
                    break;
                }
                case SETFSTRANSLATION: {
                    this.doSyncEnvironment();
                    break;
                }
                case GETEXECROOT: {
                    this.setExecPath((String)((Object)object));
                    this.doSyncEnvironment();
                    break;
                }
                case SETEXECROOT: {
                    this.doSyncEnvironment();
                    break;
                }
                case ERROR: {
                    Exception e = (Exception)object;
                    this.xcEListener.handleRXThrowable(e, this.xc, cm);
                    break;
                }
                default: {
                    FijiArchipelago.log("Got unexpected message type. The local version of Archipelago may not be up to date with the clients.");
                    break;
                }
            }
        }
        catch (ClassCastException cce) {
            FijiArchipelago.err("Caught ClassCastException while handling message " + ClusterMessage.typeToString(type) + " on " + this.getHost() + " : " + cce);
        }
        catch (NullPointerException npe) {
            FijiArchipelago.err("Expected a message object but got null for " + ClusterMessage.typeToString(type) + " on " + this.getHost());
        }
    }

    public int getMaxRamMB() {
        return this.ramMBMax.get();
    }

    public int getAvailableRamMB() {
        return this.ramMBAvail.get();
    }

    public int getTotalRamMB() {
        return this.ramMBTot.get();
    }

    public synchronized void fail() {
        if (this.state != ClusterNodeState.STOPPED && this.state != ClusterNodeState.FAILED) {
            FijiArchipelago.debug("Setting state");
            this.setState(ClusterNodeState.FAILED);
            FijiArchipelago.debug("Sending shutdown");
            this.sendShutdown();
            for (ProcessManager pm : new ArrayList<ProcessManager>(this.runningProcesses.values())) {
                this.removeProcess(pm);
            }
            FijiArchipelago.debug("Closing XC");
            this.xc.close();
            FijiArchipelago.debug("Node: Fail finished");
        } else {
            FijiArchipelago.debug("Node: Fail() called, but I'm already stopped");
        }
    }

    public synchronized void close() {
        if (this.state != ClusterNodeState.STOPPED && this.state != ClusterNodeState.FAILED) {
            FijiArchipelago.debug("Setting state");
            this.setState(ClusterNodeState.STOPPED);
            FijiArchipelago.debug("Sending shutdown");
            this.sendShutdown();
            for (ProcessManager pm : new ArrayList<ProcessManager>(this.runningProcesses.values())) {
                this.removeProcess(pm);
            }
            if (this.xc != null) {
                FijiArchipelago.debug("Closing XC");
                this.xc.close();
            }
            FijiArchipelago.debug("Node: Close finished");
        } else {
            FijiArchipelago.debug("Node: Close() called, but I'm already stopped");
        }
    }

    private boolean sendShutdown() {
        return this.xc != null && this.xc.queueMessage(MessageType.HALT);
    }

    public static String stateString(ClusterNodeState state) {
        switch (state) {
            case ACTIVE: {
                return "active";
            }
            case WAITING: {
                return "waiting";
            }
            case INACTIVE: {
                return "inactive";
            }
            case STOPPED: {
                return "stopped";
            }
            case FAILED: {
                return "failed";
            }
        }
        return "unknown";
    }

    protected synchronized void setState(ClusterNodeState nextState) {
        if (this.state != nextState) {
            ClusterNodeState lastState = this.state;
            this.state = nextState;
            FijiArchipelago.debug(this.getHost() + " state changed from " + ClusterNode.stateString(lastState) + " to " + ClusterNode.stateString(nextState) + ", updating " + this.stateListeners.size() + " listeners");
            for (NodeStateListener listener : new ArrayList<NodeStateListener>(this.stateListeners)) {
                FijiArchipelago.debug("Updating listener: " + listener.getClass().getName());
                listener.stateChanged(this, this.state, lastState);
            }
        }
    }

    public boolean cancelJob(long id) {
        ProcessManager pm = this.runningProcesses.get(id);
        if (pm == null) {
            return false;
        }
        if (this.xc.queueMessage(MessageType.CANCELJOB, Long.valueOf(id))) {
            this.removeProcess(pm);
            return true;
        }
        return false;
    }

    private void removeProcess(ProcessManager pm) {
        this.runningProcesses.remove(pm.getID());
        this.processHandlers.remove(pm.getID());
        this.runningCores.addAndGet(-pm.requestedCores(this));
    }

    public List<ProcessManager> getRunningProcesses() {
        return new ArrayList<ProcessManager>(this.runningProcesses.values());
    }

    public void addListener(NodeStateListener listener) {
        this.stateListeners.add(listener);
        listener.stateChanged(this, this.state, ClusterNodeState.INACTIVE);
    }

    public void addBottler(Bottler bottler) {
        this.xc.addBottler(bottler);
        if (bottler.transfer()) {
            this.xc.queueMessage(MessageType.BOTTLER, bottler);
        }
    }

    public void removeListener(NodeStateListener listener) {
        this.stateListeners.remove(listener);
    }

    public ClusterNodeState getState() {
        return this.state;
    }

    public String toString() {
        return this.getHost();
    }

    public synchronized void start(NodeShellListener listener) throws ShellExecutionException {
        FijiArchipelago.debug("Node " + this + " start called");
        if (this.state == ClusterNodeState.INACTIVE) {
            this.setState(ClusterNodeState.WAITING);
            if (!this.nodeParam.getShell().startShell(this.nodeParam, listener)) {
                FijiArchipelago.err("Could not start shell for " + this.nodeParam);
                this.setState(ClusterNodeState.FAILED);
            }
        }
    }
}

