/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.network.node;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.data.ClusterMessage;
import edu.utexas.clm.archipelago.exception.ShellExecutionException;
import edu.utexas.clm.archipelago.listen.ClusterStateListener;
import edu.utexas.clm.archipelago.listen.MessageType;
import edu.utexas.clm.archipelago.listen.NodeShellListener;
import edu.utexas.clm.archipelago.listen.NodeStateListener;
import edu.utexas.clm.archipelago.listen.TransceiverExceptionListener;
import edu.utexas.clm.archipelago.listen.TransceiverListener;
import edu.utexas.clm.archipelago.network.MessageXC;
import edu.utexas.clm.archipelago.network.node.ClusterNode;
import edu.utexas.clm.archipelago.network.node.ClusterNodeState;
import edu.utexas.clm.archipelago.network.node.NodeParameters;
import edu.utexas.clm.archipelago.network.shell.DummyNodeShell;
import edu.utexas.clm.archipelago.network.translation.Bottler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class NodeCoordinator
implements NodeStateListener,
NodeShellListener,
ClusterStateListener {
    private final ReentrantLock nodeLock;
    private final Set<ClusterNode> allNodes;
    private final Set<ClusterNode> runningNodes;
    private final Set<ClusterNode> waitingNodes;
    private final Vector<Bottler> bottlers;
    private final Vector<NodeInitializer> nodeInitializers;
    private final Vector<Thread> nodeStartThreads;
    private final Cluster cluster;
    private final NodeCoordinator self;
    private final TransceiverExceptionListener tel;

    public NodeCoordinator(Cluster cluster) {
        this.cluster = cluster;
        this.self = this;
        this.nodeLock = new ReentrantLock();
        this.allNodes = new HashSet<ClusterNode>();
        this.runningNodes = new HashSet<ClusterNode>();
        this.waitingNodes = new HashSet<ClusterNode>();
        this.bottlers = new Vector();
        this.nodeInitializers = new Vector();
        this.nodeStartThreads = new Vector();
        this.tel = new TransceiverExceptionListener(){

            @Override
            public void handleRXThrowable(Throwable t, MessageXC mxc, ClusterMessage message) {
                FijiArchipelago.debug("Exception: " + t, t);
            }

            @Override
            public void handleTXThrowable(Throwable t, MessageXC mxc, ClusterMessage message) {
                FijiArchipelago.debug("Exception: " + t, t);
            }
        };
        cluster.addStateListener(this);
    }

    private void nodeInitializerDone(NodeInitializer ni) {
        this.nodeInitializers.remove(ni);
    }

    @Override
    public void stateChanged(ClusterNode node, ClusterNodeState stateNow, ClusterNodeState lastState) {
        this.nodeLock.lock();
        this.allNodes.add(node);
        this.nodeLock.unlock();
        switch (stateNow) {
            case WAITING: {
                this.nodeLock.lock();
                this.waitingNodes.add(node);
                this.nodeLock.unlock();
                break;
            }
            case ACTIVE: {
                this.nodeLock.lock();
                FijiArchipelago.debug("Got state change to active for " + node.getHost());
                this.waitingNodes.remove(node);
                this.runningNodes.add(node);
                this.nodeLock.unlock();
                this.cluster.nodeStarted();
                for (Bottler bottler : this.bottlers) {
                    node.addBottler(bottler);
                }
                break;
            }
            case STOPPED: 
            case FAILED: {
                this.nodeLock.lock();
                FijiArchipelago.debug("Got state change to " + ClusterNode.stateString(stateNow) + " for " + node.getHost());
                this.runningNodes.remove(node);
                this.waitingNodes.remove(node);
                this.allNodes.remove(node);
                this.nodeLock.unlock();
                this.cluster.nodeStopped(node, this.runningNodes.size());
            }
        }
        this.cluster.triggerListeners();
    }

    @Override
    public void stateChanged(Cluster cluster) {
        if (cluster.getState() == Cluster.ClusterState.STARTED || cluster.getState() == Cluster.ClusterState.RUNNING) {
            this.nodeLock.lock();
            for (Thread t : this.nodeStartThreads) {
                t.start();
            }
            this.nodeStartThreads.clear();
            this.nodeLock.unlock();
        }
    }

    public void startNode(NodeParameters params) {
        ClusterNode node = new ClusterNode(params, this.tel);
        this.startNode(node);
    }

    public void startNode(final ClusterNode node) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    node.start(NodeCoordinator.this.self);
                }
                catch (ShellExecutionException see) {
                    node.setState(ClusterNodeState.FAILED);
                    FijiArchipelago.err(see.getMessage());
                }
            }
        };
        this.nodeLock.lock();
        this.allNodes.add(node);
        if (this.cluster.getState() == Cluster.ClusterState.RUNNING || this.cluster.getState() == Cluster.ClusterState.STARTED) {
            t.start();
        } else {
            this.nodeStartThreads.add(t);
        }
        this.nodeLock.unlock();
        FijiArchipelago.debug("NodeCoordinator started node " + node);
        node.addListener(this);
    }

    public Set<ClusterNode> getNodes() {
        this.nodeLock.lock();
        HashSet<ClusterNode> nodesOut = new HashSet<ClusterNode>(this.allNodes);
        this.nodeLock.unlock();
        return nodesOut;
    }

    public Set<ClusterNode> getRunningNodes() {
        this.nodeLock.lock();
        HashSet<ClusterNode> nodesOut = new HashSet<ClusterNode>(this.runningNodes);
        this.nodeLock.unlock();
        return nodesOut;
    }

    public Set<ClusterNode> getAvailableNodes() {
        HashSet<ClusterNode> nodesOut = new HashSet<ClusterNode>();
        this.nodeLock.lock();
        for (ClusterNode node : this.runningNodes) {
            if (node.numAvailableThreads() <= 0) continue;
            nodesOut.add(node);
        }
        this.nodeLock.unlock();
        return nodesOut;
    }

    public int numRunningNodes() {
        this.nodeLock.lock();
        int n = this.runningNodes.size();
        this.nodeLock.unlock();
        return n;
    }

    public int numWaitingNodes() {
        this.nodeLock.lock();
        int n = this.waitingNodes.size();
        this.nodeLock.unlock();
        return n;
    }

    public void reset() {
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(this.allNodes);
        this.nodeLock.lock();
        this.allNodes.clear();
        this.waitingNodes.clear();
        this.runningNodes.clear();
        this.nodeLock.unlock();
        for (ClusterNode node : nodes) {
            node.close();
        }
    }

    private ClusterNode findNode(long id) {
        for (ClusterNode node : this.allNodes) {
            if (node.getID() != id) continue;
            return node;
        }
        return null;
    }

    public ClusterNode getNode(long id) {
        this.nodeLock.lock();
        ClusterNode node = this.findNode(id);
        this.nodeLock.unlock();
        return node;
    }

    @Override
    public void execFinished(long nodeID, Exception e, int status) {
        ClusterNode node = this.getNode(nodeID);
        if (node.isReady()) {
            node.close();
        }
    }

    @Override
    public void ioStreamsReady(InputStream is, OutputStream os) {
        try {
            NodeInitializer ni = new NodeInitializer(is, os);
            this.nodeInitializers.add(ni);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void addBottler(Bottler bottler) {
        this.bottlers.add(bottler);
        this.nodeLock.lock();
        for (ClusterNode node : this.runningNodes) {
            node.addBottler(bottler);
        }
        this.nodeLock.unlock();
    }

    public synchronized ArrayList<Bottler> getBottlers() {
        return new ArrayList<Bottler>(this.bottlers);
    }

    public ArrayList<NodeParameters> getParameters() {
        this.nodeLock.lock();
        ArrayList<NodeParameters> params = new ArrayList<NodeParameters>(this.allNodes.size());
        for (ClusterNode node : this.allNodes) {
            params.add(node.getParam());
        }
        this.nodeLock.unlock();
        return params;
    }

    private class NodeInitializer
    implements TransceiverListener {
        MessageXC xc;
        InputStream is;
        OutputStream os;
        final AtomicBoolean isVolunteer;
        final AtomicBoolean setHost;
        final AtomicBoolean setUser;
        final AtomicBoolean setExec;
        String hostName;
        String userName;
        String execRoot;
        long nodeId;

        public NodeInitializer(InputStream is, OutputStream os) throws IOException {
            this.is = is;
            this.os = os;
            this.isVolunteer = new AtomicBoolean(false);
            this.setHost = new AtomicBoolean(false);
            this.setUser = new AtomicBoolean(false);
            this.setExec = new AtomicBoolean(false);
            this.nodeId = -1L;
            this.userName = null;
            this.execRoot = null;
            this.hostName = null;
            this.xc = new MessageXC(is, os, this, NodeCoordinator.this.tel);
            this.xc.queueMessage(MessageType.GETID);
            FijiArchipelago.debug("NodeInitializer: leaving constructor");
        }

        private void cleanup() {
            this.xc = null;
            this.is = null;
            this.os = null;
            NodeCoordinator.this.nodeInitializerDone(this);
        }

        private void initVolunteer() {
            if (!this.isVolunteer.getAndSet(true)) {
                this.nodeId = FijiArchipelago.getUniqueID();
                this.xc.setId(this.nodeId);
                this.xc.queueMessage(MessageType.SETID, Long.valueOf(this.nodeId));
            }
        }

        private void setupVolunteer() {
            if (this.setHost.get()) {
                NodeParameters params = new NodeParameters(this.userName, this.hostName, new DummyNodeShell(), this.execRoot, "", NodeCoordinator.this.cluster.getParametersFactory(), this.nodeId);
                ClusterNode node = new ClusterNode(params, NodeCoordinator.this.tel);
                node.setMessageXC(this.xc);
                node.addListener(NodeCoordinator.this.self);
                this.cleanup();
            }
        }

        @Override
        public void streamClosed() {
        }

        @Override
        public void handleMessage(ClusterMessage cm) {
            MessageType type = cm.type;
            Serializable object = cm.o;
            try {
                switch (type) {
                    case GETID: {
                        long id = (Long)object;
                        FijiArchipelago.debug("Node initializer: got id " + id);
                        if (id > 0L) {
                            ClusterNode node = NodeCoordinator.this.getNode(id);
                            if (node != null) {
                                FijiArchipelago.debug("Found an existing node, setting streams");
                                this.xc.setId(id);
                                node.setMessageXC(this.xc);
                                this.cleanup();
                                break;
                            }
                            this.initVolunteer();
                            break;
                        }
                        this.initVolunteer();
                        break;
                    }
                    case SETID: {
                        this.xc.queueMessage(MessageType.HOSTNAME);
                        break;
                    }
                    case HOSTNAME: {
                        String name = (String)((Object)object);
                        FijiArchipelago.debug("Intializer for " + this.nodeId + " got name " + name);
                        this.hostName = name.equals("") ? "Host " + this.nodeId : name;
                        this.setHost.set(true);
                        this.setupVolunteer();
                        break;
                    }
                    case USER: {
                        this.userName = (String)((Object)object);
                        this.setUser.set(true);
                        this.setupVolunteer();
                        break;
                    }
                    case GETEXECROOT: {
                        this.execRoot = (String)((Object)object);
                        this.setExec.set(true);
                        this.setupVolunteer();
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }
}

