/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.threshold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.event.OverlayDeletedEvent;
import net.imagej.overlay.Overlay;
import net.imagej.overlay.ThresholdOverlay;
import net.imagej.threshold.ThresholdMethod;
import net.imagej.threshold.ThresholdService;
import org.scijava.display.Display;
import org.scijava.display.event.DisplayDeletedEvent;
import org.scijava.event.EventHandler;
import org.scijava.log.LogService;
import org.scijava.plugin.AbstractSingletonService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.Service;

@Deprecated
@Plugin(type=Service.class)
public class DefaultThresholdService
extends AbstractSingletonService<ThresholdMethod>
implements ThresholdService {
    @Parameter
    private ImageDisplayService displayService;
    @Parameter
    private OverlayService overlayService;
    @Parameter
    private LogService log;
    private ConcurrentHashMap<ImageDisplay, ThresholdOverlay> thresholdMap;
    private HashMap<String, ThresholdMethod> methods;
    private ArrayList<String> methodNames;

    @Override
    public boolean hasThreshold(ImageDisplay display) {
        return this.thresholdMap().get(display) != null;
    }

    @Override
    public ThresholdOverlay getThreshold(ImageDisplay display) {
        ThresholdOverlay overlay = this.thresholdMap().get(display);
        if (overlay == null) {
            Dataset dataset = this.displayService.getActiveDataset(display);
            if (dataset == null) {
                throw new IllegalArgumentException("expected ImageDisplay to have active dataset");
            }
            overlay = new ThresholdOverlay(this.getContext(), dataset);
            this.thresholdMap().put(display, overlay);
            display.display((Object)overlay);
            display.update();
        }
        return overlay;
    }

    @Override
    public void removeThreshold(ImageDisplay display) {
        ThresholdOverlay overlay = this.thresholdMap().get(display);
        if (overlay != null) {
            this.overlayService.removeOverlay(display, (Overlay)overlay);
            this.thresholdMap().remove(display);
        }
    }

    @Override
    public Map<String, ThresholdMethod> getThresholdMethods() {
        return Collections.unmodifiableMap(this.methods());
    }

    @Override
    public List<String> getThresholdMethodNames() {
        return Collections.unmodifiableList(this.methodNames());
    }

    @Override
    public ThresholdMethod getThresholdMethod(String name) {
        return this.methods().get(name);
    }

    public Class<ThresholdMethod> getPluginType() {
        return ThresholdMethod.class;
    }

    @EventHandler
    protected void onEvent(DisplayDeletedEvent evt) {
        Display display = evt.getObject();
        if (display instanceof ImageDisplay) {
            this.removeThreshold((ImageDisplay)display);
        }
    }

    @EventHandler
    protected void onEvent(OverlayDeletedEvent evt) {
        Overlay overlay = evt.getObject();
        if (overlay instanceof ThresholdOverlay) {
            for (Map.Entry<ImageDisplay, ThresholdOverlay> entry : this.thresholdMap().entrySet()) {
                if (entry.getValue() != overlay) continue;
                this.removeThreshold(entry.getKey());
            }
        }
    }

    private ConcurrentHashMap<ImageDisplay, ThresholdOverlay> thresholdMap() {
        if (this.thresholdMap == null) {
            this.initThresholdMap();
        }
        return this.thresholdMap;
    }

    private HashMap<String, ThresholdMethod> methods() {
        if (this.methods == null) {
            this.initMethods();
        }
        return this.methods;
    }

    private List<String> methodNames() {
        if (this.methodNames == null) {
            this.initMethodNames();
        }
        return this.methodNames;
    }

    private synchronized void initThresholdMap() {
        if (this.thresholdMap != null) {
            return;
        }
        ConcurrentHashMap map = new ConcurrentHashMap();
        this.thresholdMap = map;
    }

    private synchronized void initMethods() {
        if (this.methods != null) {
            return;
        }
        HashMap<String, ThresholdMethod> map = new HashMap<String, ThresholdMethod>();
        for (ThresholdMethod method : this.getInstances()) {
            String name = method.getInfo().getName();
            map.put(name, method);
        }
        this.methods = map;
    }

    private synchronized void initMethodNames() {
        if (this.methodNames != null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (ThresholdMethod method : this.getInstances()) {
            String name = method.getInfo().getName();
            list.add(name);
        }
        this.methodNames = list;
    }
}

