/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.function.real;

import java.util.Arrays;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.ops.util.Tuple2;
import net.imglib2.type.numeric.RealType;
import org.scijava.util.DoubleArray;

@Deprecated
public class StatCalculator<T extends RealType<T>> {
    private Function<long[], T> func;
    private PointSet region;
    private PointSetIterator iter;
    private final DoubleArray values;

    public StatCalculator(Function<long[], T> func, PointSet region) {
        this.func = func;
        this.region = region;
        this.iter = region.iterator();
        this.values = new DoubleArray();
    }

    public void reset(Function<long[], T> newFunc, PointSet newRegion) {
        this.func = newFunc;
        if (newRegion == this.region) {
            this.iter.reset();
        } else {
            this.region = newRegion;
            this.iter = this.region.iterator();
        }
        this.values.clear();
    }

    public double alphaTrimmedMean(double alpha) {
        if (alpha < 0.0 || alpha >= 0.5) {
            throw new IllegalArgumentException("alpha value must be >= 0 and < 0.5");
        }
        RealType tmp = (RealType)this.func.createOutput();
        this.values.clear();
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            this.values.add((Object)tmp.getRealDouble());
        }
        Arrays.sort(this.values.getArray(), 0, this.values.size());
        double tailSize = alpha * (double)this.values.size();
        if (tailSize == Math.floor(tailSize)) {
            return this.calcTrimmedMean(this.values, (int)tailSize);
        }
        double mean1 = this.calcTrimmedMean(this.values, (int)Math.floor(tailSize));
        double mean2 = this.calcTrimmedMean(this.values, (int)Math.ceil(tailSize));
        double fraction = tailSize - Math.floor(tailSize);
        double interpolation = (1.0 - fraction) * mean1 + fraction * mean2;
        return interpolation;
    }

    public double arithmeticMean() {
        RealType tmp = (RealType)this.func.createOutput();
        double sum = 0.0;
        long numElements = 0L;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            sum += tmp.getRealDouble();
            ++numElements;
        }
        return sum / (double)numElements;
    }

    public Tuple2<Double, Double> centerOfMassXY() {
        RealType tmp = (RealType)this.func.createOutput();
        double sumV = 0.0;
        double sumX = 0.0;
        double sumY = 0.0;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            double v = tmp.getRealDouble();
            sumV += v;
            sumX += v * (double)pos[0];
            sumY += v * (double)pos[1];
        }
        double cx = sumX / sumV + 0.5;
        double cy = sumY / sumV + 0.5;
        return new Tuple2<Double, Double>(cx, cy);
    }

    public Tuple2<Double, Double> centroidXY() {
        double sumX = 0.0;
        double sumY = 0.0;
        long numElements = 0L;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            sumX += (double)pos[0];
            sumY += (double)pos[1];
            ++numElements;
        }
        double cx = sumX / (double)numElements + 0.5;
        double cy = sumY / (double)numElements + 0.5;
        return new Tuple2<Double, Double>(cx, cy);
    }

    public double contraharmonicMean(double order) {
        RealType tmp = (RealType)this.func.createOutput();
        double sum1 = 0.0;
        double sum2 = 0.0;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            double value = tmp.getRealDouble();
            sum1 += Math.pow(value, order + 1.0);
            sum2 += Math.pow(value, order);
        }
        return sum1 / sum2;
    }

    public double geometricMean() {
        return Math.pow(this.product(), 1.0 / (double)this.region.size());
    }

    public double harmonicMean() {
        RealType tmp = (RealType)this.func.createOutput();
        double sum = 0.0;
        long numElements = 0L;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            double value = tmp.getRealDouble();
            sum += 1.0 / value;
            ++numElements;
        }
        return (double)numElements / sum;
    }

    public double max() {
        RealType tmp = (RealType)this.func.createOutput();
        double max = Double.NEGATIVE_INFINITY;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            double value = tmp.getRealDouble();
            max = Math.max(max, value);
        }
        return max;
    }

    public double median() {
        RealType tmp = (RealType)this.func.createOutput();
        this.values.clear();
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            this.values.add((Object)tmp.getRealDouble());
        }
        int count = this.values.size();
        if (count <= 0) {
            throw new IllegalArgumentException("number of samples must be greater than 0");
        }
        Arrays.sort(this.values.getArray(), 0, count);
        if (count % 2 == 1) {
            return this.values.getValue(count / 2);
        }
        double value1 = this.values.getValue(count / 2 - 1);
        double value2 = this.values.getValue(count / 2);
        return (value1 + value2) / 2.0;
    }

    public double midpoint() {
        return (this.min() + this.max()) / 2.0;
    }

    public double min() {
        RealType tmp = (RealType)this.func.createOutput();
        double min = Double.POSITIVE_INFINITY;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            double value = tmp.getRealDouble();
            min = Math.min(min, value);
        }
        return min;
    }

    public double populationKurtosis() {
        RealType tmp = (RealType)this.func.createOutput();
        double xbar = this.arithmeticMean();
        double s2 = 0.0;
        double s4 = 0.0;
        long numElements = 0L;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            double value = tmp.getRealDouble();
            ++numElements;
            double v = value - xbar;
            double v2 = v * v;
            double v4 = v2 * v2;
            s2 += v2;
            s4 += v4;
        }
        double n = numElements;
        double m2 = s2 / n;
        double m4 = s4 / n;
        return m4 / (m2 * m2);
    }

    public double populationKurtosisExcess() {
        return this.populationKurtosis() - 3.0;
    }

    public double populationSkew() {
        RealType tmp = (RealType)this.func.createOutput();
        double xbar = this.arithmeticMean();
        double s2 = 0.0;
        double s3 = 0.0;
        long numElements = 0L;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            double value = tmp.getRealDouble();
            ++numElements;
            double v = value - xbar;
            double v2 = v * v;
            double v3 = v2 * v;
            s2 += v2;
            s3 += v3;
        }
        double n = numElements;
        double m2 = s2 / n;
        double m3 = s3 / n;
        return m3 / Math.pow(m2, 1.5);
    }

    public double populationStdDev() {
        return Math.sqrt(this.populationVariance());
    }

    public double populationVariance() {
        double sum = this.sumOfSquaredDeviations();
        long numElements = this.region.size();
        return sum / (double)numElements;
    }

    public double product() {
        RealType tmp = (RealType)this.func.createOutput();
        double prod = 1.0;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            double value = tmp.getRealDouble();
            prod *= value;
        }
        return prod;
    }

    public double sampleKurtosis() {
        double n = this.region.size();
        double biasedValue = this.populationKurtosis();
        double unbiasedValue = biasedValue * (n + 1.0) + 6.0;
        return unbiasedValue *= (n - 1.0) / ((n - 2.0) * (n - 3.0));
    }

    public double sampleKurtosisExcess() {
        return this.sampleKurtosis() - 3.0;
    }

    public double sampleSkew() {
        double n = this.region.size();
        double biasedValue = this.populationSkew();
        double unbiasedValue = biasedValue * Math.sqrt(n * (n - 1.0)) / (n - 2.0);
        return unbiasedValue;
    }

    public double sampleStdDev() {
        return Math.sqrt(this.sampleVariance());
    }

    public double sampleVariance() {
        double sum = this.sumOfSquaredDeviations();
        long numElements = this.region.size();
        return sum / (double)(numElements - 1L);
    }

    public double sum() {
        RealType tmp = (RealType)this.func.createOutput();
        double sum = 0.0;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            double value = tmp.getRealDouble();
            sum += value;
        }
        return sum;
    }

    public double sumOfSquaredDeviations() {
        RealType tmp = (RealType)this.func.createOutput();
        double xbar = this.arithmeticMean();
        double sum = 0.0;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            double value = tmp.getRealDouble();
            double term = value - xbar;
            sum += term * term;
        }
        return sum;
    }

    public double trimmedMean(int halfTrimSize) {
        RealType tmp = (RealType)this.func.createOutput();
        this.values.clear();
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            this.values.add((Object)tmp.getRealDouble());
        }
        Arrays.sort(this.values.getArray(), 0, this.values.size());
        return this.calcTrimmedMean(this.values, halfTrimSize);
    }

    public double weightedAverage(double[] weights) {
        long numElements = this.region.size();
        if (numElements != (long)weights.length) {
            throw new IllegalArgumentException("number of weights does not equal number of samples");
        }
        double sum = this.weightedSum(weights);
        return sum / (double)numElements;
    }

    public double weightedSum(double[] weights) {
        long numElements = this.region.size();
        if (numElements != (long)weights.length) {
            throw new IllegalArgumentException("number of weights does not equal number of samples");
        }
        RealType tmp = (RealType)this.func.createOutput();
        double sum = 0.0;
        int i = 0;
        this.iter.reset();
        while (this.iter.hasNext()) {
            long[] pos = (long[])this.iter.next();
            this.func.compute(pos, tmp);
            double value = tmp.getRealDouble();
            sum += weights[i++] * value;
        }
        return sum;
    }

    private double calcTrimmedMean(DoubleArray vals, int halfTrim) {
        int trimSize = halfTrim * 2;
        int numElem = vals.size();
        if (numElem <= trimSize) {
            throw new IllegalArgumentException("number of samples must be greater than number of trimmed values");
        }
        int top = numElem - halfTrim;
        double sum = 0.0;
        for (int i = halfTrim; i < top; ++i) {
            sum += vals.getValue(i);
        }
        return sum / (double)(numElem - trimSize);
    }
}

