/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imglib2.ops.condition.AndCondition;
import net.imglib2.ops.condition.BinaryFunctionalCondition;
import net.imglib2.ops.condition.Condition;
import net.imglib2.ops.condition.DimensionEqualCondition;
import net.imglib2.ops.condition.NotCondition;
import net.imglib2.ops.condition.OrCondition;
import net.imglib2.ops.condition.RangeCondition;
import net.imglib2.ops.condition.UnionCondition;
import net.imglib2.ops.condition.XorCondition;
import net.imglib2.ops.parse.EquationParser;
import net.imglib2.ops.parse.Lexer;
import net.imglib2.ops.parse.ParseStatus;
import net.imglib2.ops.parse.ParseUtils;
import net.imglib2.ops.parse.token.And;
import net.imglib2.ops.parse.token.Assign;
import net.imglib2.ops.parse.token.CloseRange;
import net.imglib2.ops.parse.token.Comma;
import net.imglib2.ops.parse.token.DotDot;
import net.imglib2.ops.parse.token.Equal;
import net.imglib2.ops.parse.token.Greater;
import net.imglib2.ops.parse.token.GreaterEqual;
import net.imglib2.ops.parse.token.Int;
import net.imglib2.ops.parse.token.Less;
import net.imglib2.ops.parse.token.LessEqual;
import net.imglib2.ops.parse.token.Minus;
import net.imglib2.ops.parse.token.Not;
import net.imglib2.ops.parse.token.NotEqual;
import net.imglib2.ops.parse.token.OpenRange;
import net.imglib2.ops.parse.token.Or;
import net.imglib2.ops.parse.token.Plus;
import net.imglib2.ops.parse.token.Token;
import net.imglib2.ops.parse.token.Variable;
import net.imglib2.ops.parse.token.Xor;
import net.imglib2.ops.pointset.AbstractPointSet;
import net.imglib2.ops.pointset.ConditionalPointSet;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.relation.real.binary.RealEquals;
import net.imglib2.ops.relation.real.binary.RealGreaterThan;
import net.imglib2.ops.relation.real.binary.RealGreaterThanOrEqual;
import net.imglib2.ops.relation.real.binary.RealLessThan;
import net.imglib2.ops.relation.real.binary.RealLessThanOrEqual;
import net.imglib2.ops.relation.real.binary.RealNotEquals;
import net.imglib2.ops.util.Tuple2;
import net.imglib2.type.numeric.real.DoubleType;

@Deprecated
public class PointSetParser {
    private Map<String, Integer> varMap;
    private List<Long> minDims;
    private List<Long> maxDims;
    private List<Condition<long[]>> conditions;
    private EquationParser eqnParser;

    public Tuple2<PointSet, String> parse(String specification) {
        this.minDims = new ArrayList<Long>();
        this.maxDims = new ArrayList<Long>();
        this.conditions = new ArrayList<Condition<long[]>>();
        this.varMap = new HashMap<String, Integer>();
        this.eqnParser = new EquationParser(this.varMap, null);
        Lexer lexer = new Lexer();
        ParseStatus lexResult = lexer.tokenize(specification, this.varMap);
        if (lexResult.errMsg != null) {
            return new Tuple2<PointSet, String>(lexResult.pointSet, lexResult.errMsg);
        }
        ParseStatus parseResult = this.constructPointSet(lexResult.tokens);
        return new Tuple2<PointSet, String>(parseResult.pointSet, parseResult.errMsg);
    }

    private ParseStatus constructPointSet(List<Token> tokens) {
        return this.statement(tokens);
    }

    private ParseStatus statement(List<Token> tokens) {
        ParseStatus status = this.dimensions(tokens, 0);
        if (status.errMsg != null) {
            return status;
        }
        long[] minPt = new long[this.minDims.size()];
        long[] maxPt = new long[this.maxDims.size()];
        for (int i = 0; i < this.minDims.size(); ++i) {
            minPt[i] = this.minDims.get(i);
            maxPt[i] = this.maxDims.get(i);
        }
        AbstractPointSet ps = new HyperVolumePointSet(minPt, maxPt);
        if (ParseUtils.match(Comma.class, tokens, status.tokenNumber)) {
            status = this.restrictions(tokens, status.tokenNumber + 1);
            if (status.errMsg != null) {
                return status;
            }
        }
        for (Condition<long[]> condition : this.conditions) {
            ps = new ConditionalPointSet(ps, condition);
        }
        status.pointSet = ps;
        return status;
    }

    private ParseStatus dimensions(List<Token> tokens, int currPos) {
        ParseStatus status = this.dimension(tokens, currPos);
        if (status.errMsg != null) {
            return status;
        }
        if (ParseUtils.match(Comma.class, tokens, status.tokenNumber) && ParseUtils.match(Variable.class, tokens, status.tokenNumber + 1) && ParseUtils.match(Assign.class, tokens, status.tokenNumber + 2)) {
            return this.dimensions(tokens, status.tokenNumber + 1);
        }
        return status;
    }

    private ParseStatus dimension(List<Token> tokens, int pos) {
        if (!ParseUtils.match(Variable.class, tokens, pos)) {
            return ParseUtils.syntaxError(pos, tokens, "Expected a variable name.");
        }
        if (!ParseUtils.match(Assign.class, tokens, pos + 1)) {
            return ParseUtils.syntaxError(pos + 1, tokens, "Expected an assignment symbol '='.");
        }
        if (!ParseUtils.match(OpenRange.class, tokens, pos + 2)) {
            return ParseUtils.syntaxError(pos + 2, tokens, "Expected an open bracket symbol '['.");
        }
        ParseStatus valsStatus = this.values(tokens, pos + 3);
        if (valsStatus.errMsg != null) {
            return valsStatus;
        }
        if (!ParseUtils.match(CloseRange.class, tokens, valsStatus.tokenNumber)) {
            return ParseUtils.syntaxError(valsStatus.tokenNumber, tokens, "Expected a close bracket symbol ']'.");
        }
        Variable var = (Variable)tokens.get(pos);
        int dimIndex = this.varMap.get(var.getText());
        if (dimIndex >= 0) {
            return ParseUtils.syntaxError(pos, tokens, "Cannot declare dimension (" + var.getText() + ") more than once");
        }
        this.varMap.put(var.getText(), -dimIndex - 1);
        this.minDims.add(valsStatus.minDim);
        this.maxDims.add(valsStatus.maxDim);
        return ParseUtils.nextPosition(valsStatus.tokenNumber + 1);
    }

    private ParseStatus values(List<Token> tokens, int pos) {
        if (this.intsAndCommas(tokens, pos)) {
            ArrayList<Long> dims = new ArrayList<Long>();
            ParseStatus status = this.intList(tokens, pos, dims);
            if (status.errMsg != null) {
                return status;
            }
            this.conditions.add(this.dimListRestriction(this.minDims.size(), dims));
            return status;
        }
        return this.range(tokens, pos);
    }

    private ParseStatus range(List<Token> tokens, int pos) {
        ParseStatus status1 = this.integer(tokens, pos);
        if (status1.errMsg != null) {
            return status1;
        }
        if (ParseUtils.match(DotDot.class, tokens, status1.tokenNumber)) {
            ParseStatus status2 = this.integer(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status1;
            }
            long first = status1.minDim;
            long second = status2.minDim;
            if (first > second) {
                return ParseUtils.syntaxError(status2.tokenNumber, tokens, "In a range the first value must be <= last value.");
            }
            ParseStatus status = new ParseStatus();
            this.conditions.add(new RangeCondition(this.minDims.size(), first, second, 1L));
            status.minDim = first;
            status.maxDim = second;
            status.tokenNumber = status2.tokenNumber;
            return status;
        }
        if (ParseUtils.match(Comma.class, tokens, status1.tokenNumber)) {
            ParseStatus status2 = this.integer(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status2;
            }
            if (!ParseUtils.match(DotDot.class, tokens, status2.tokenNumber)) {
                return ParseUtils.syntaxError(status2.tokenNumber, tokens, "Expected '..' after integer in range definition.");
            }
            ParseStatus status3 = this.integer(tokens, status2.tokenNumber + 1);
            if (status3.errMsg != null) {
                return status3;
            }
            long first = status1.minDim;
            long second = status2.minDim;
            long third = status3.minDim;
            long by = second - first;
            if (by <= 0L) {
                return ParseUtils.syntaxError(status2.tokenNumber, tokens, "In a range the difference between the 1st and 2nd number must be >= 0.");
            }
            if (first > third) {
                return ParseUtils.syntaxError(status3.tokenNumber, tokens, "In a range the 1st integer must be <= 3rd integer.");
            }
            long last = first;
            for (long i = first; i <= third; i += by) {
                last = i;
            }
            this.conditions.add(new RangeCondition(this.minDims.size(), first, last, by));
            status3.minDim = first;
            status3.maxDim = last;
            return status3;
        }
        return ParseUtils.syntaxError(pos + 1, tokens, "Unexpected token in range definition.");
    }

    private ParseStatus intList(List<Token> tokens, int pos, List<Long> values) {
        ParseStatus status1 = this.integer(tokens, pos);
        if (status1.errMsg != null) {
            return status1;
        }
        values.add(status1.minDim);
        if (ParseUtils.match(Comma.class, tokens, status1.tokenNumber)) {
            ParseStatus status2 = this.intList(tokens, status1.tokenNumber + 1, values);
            if (status2.errMsg != null) {
                return status2;
            }
            status2.maxDim = Math.max(status1.maxDim, status2.maxDim);
            status2.minDim = Math.min(status1.minDim, status2.minDim);
            return status2;
        }
        return status1;
    }

    private ParseStatus integer(List<Token> tokens, int pos) {
        int p = pos;
        long multiplier = 1L;
        if (ParseUtils.match(Plus.class, tokens, p)) {
            ++p;
            multiplier = 1L;
        } else if (ParseUtils.match(Minus.class, tokens, p)) {
            ++p;
            multiplier = -1L;
        }
        if (!ParseUtils.match(Int.class, tokens, p)) {
            return ParseUtils.syntaxError(p, tokens, "Expected an integer.");
        }
        Int i = (Int)tokens.get(p);
        long value = multiplier * i.getValue();
        ParseStatus status = new ParseStatus();
        status.minDim = value;
        status.maxDim = value;
        status.tokenNumber = p + 1;
        return status;
    }

    private ParseStatus restrictions(List<Token> tokens, int pos) {
        ParseStatus status = this.compoundBoolExpression(tokens, pos);
        if (status.errMsg != null) {
            return status;
        }
        this.conditions.add(status.condition);
        if (ParseUtils.match(Comma.class, tokens, status.tokenNumber)) {
            return this.restrictions(tokens, status.tokenNumber + 1);
        }
        return status;
    }

    private ParseStatus compoundBoolExpression(List<Token> tokens, int pos) {
        ParseStatus status1;
        ParseStatus status2 = status1 = this.boolClause(tokens, pos);
        if (status1.errMsg != null) {
            return status1;
        }
        if (ParseUtils.match(And.class, tokens, status1.tokenNumber)) {
            status2 = this.compoundBoolExpression(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status2;
            }
            status2.condition = new AndCondition<long[]>(status1.condition, status2.condition);
        } else if (ParseUtils.match(Or.class, tokens, status1.tokenNumber)) {
            status2 = this.compoundBoolExpression(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status2;
            }
            status2.condition = new OrCondition<long[]>(status1.condition, status2.condition);
        } else if (ParseUtils.match(Xor.class, tokens, status1.tokenNumber)) {
            status2 = this.compoundBoolExpression(tokens, status1.tokenNumber + 1);
            if (status2.errMsg != null) {
                return status2;
            }
            status2.condition = new XorCondition<long[]>(status1.condition, status2.condition);
        }
        return status2;
    }

    private ParseStatus boolClause(List<Token> tokens, int pos) {
        if (ParseUtils.match(Not.class, tokens, pos)) {
            ParseStatus status = this.expression(tokens, pos + 1);
            if (status.errMsg != null) {
                return status;
            }
            status.condition = new NotCondition<long[]>(status.condition);
            return status;
        }
        return this.expression(tokens, pos);
    }

    private ParseStatus expression(List<Token> tokens, int pos) {
        ParseStatus status1 = this.eqnParser.equation(tokens, pos);
        if (status1.errMsg != null) {
            return status1;
        }
        ParseStatus status2 = this.relop(tokens, status1.tokenNumber);
        if (status2.errMsg != null) {
            return status2;
        }
        ParseStatus status3 = this.eqnParser.equation(tokens, status2.tokenNumber);
        if (status3.errMsg != null) {
            return status3;
        }
        status3.condition = new BinaryFunctionalCondition<long[], DoubleType, DoubleType>(status1.function, status3.function, status2.relop);
        return status3;
    }

    private ParseStatus relop(List<Token> tokens, int pos) {
        ParseStatus status = new ParseStatus();
        if (ParseUtils.match(Less.class, tokens, pos)) {
            status.relop = new RealLessThan<DoubleType, DoubleType>();
            status.tokenNumber = pos + 1;
        } else if (ParseUtils.match(LessEqual.class, tokens, pos)) {
            status.relop = new RealLessThanOrEqual<DoubleType, DoubleType>();
            status.tokenNumber = pos + 1;
        } else if (ParseUtils.match(Greater.class, tokens, pos)) {
            status.relop = new RealGreaterThan<DoubleType, DoubleType>();
            status.tokenNumber = pos + 1;
        } else if (ParseUtils.match(GreaterEqual.class, tokens, pos)) {
            status.relop = new RealGreaterThanOrEqual<DoubleType, DoubleType>();
            status.tokenNumber = pos + 1;
        } else if (ParseUtils.match(Equal.class, tokens, pos)) {
            status.relop = new RealEquals<DoubleType, DoubleType>();
            status.tokenNumber = pos + 1;
        } else if (ParseUtils.match(NotEqual.class, tokens, pos)) {
            status.relop = new RealNotEquals<DoubleType, DoubleType>();
            status.tokenNumber = pos + 1;
        } else {
            return ParseUtils.syntaxError(pos, tokens, "Expected a relational operator.");
        }
        return status;
    }

    private boolean intsAndCommas(List<Token> tokens, int pos) {
        if (!ParseUtils.match(Int.class, tokens, pos)) {
            return false;
        }
        int p = pos;
        while (ParseUtils.match(Int.class, tokens, p) || ParseUtils.match(Comma.class, tokens, p)) {
            ++p;
        }
        return ParseUtils.match(CloseRange.class, tokens, p);
    }

    private UnionCondition<long[]> dimListRestriction(int dimIndex, List<Long> values) {
        ArrayList dimensionConditions = new ArrayList();
        for (long value : values) {
            DimensionEqualCondition cond = new DimensionEqualCondition(dimIndex, value);
            dimensionConditions.add(cond);
        }
        return new UnionCondition<long[]>(dimensionConditions);
    }
}

