/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.pointset;

import net.imglib2.AbstractCursor;
import net.imglib2.ops.condition.Condition;
import net.imglib2.ops.pointset.AbstractPointSet;
import net.imglib2.ops.pointset.BoundsCalculator;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetIterator;

@Deprecated
public class ConditionalPointSet
extends AbstractPointSet {
    private PointSet pointSet;
    private Condition<long[]> condition;
    private final BoundsCalculator calculator;
    private boolean needsCalc;

    public ConditionalPointSet(PointSet pointSet, Condition<long[]> condition) {
        this.pointSet = pointSet;
        this.condition = condition;
        this.calculator = new BoundsCalculator();
        this.needsCalc = true;
    }

    public Condition<long[]> getCondition() {
        return this.condition;
    }

    public void setCondition(Condition<long[]> condition) {
        this.condition = condition;
        this.invalidateBounds();
        this.needsCalc = true;
    }

    public PointSet getPointSet() {
        return this.pointSet;
    }

    public void setPointSet(PointSet ps) {
        this.pointSet = ps;
        this.invalidateBounds();
        this.needsCalc = true;
    }

    @Override
    public long[] getOrigin() {
        return this.pointSet.getOrigin();
    }

    @Override
    public void translate(long[] deltas) {
        this.pointSet.translate(deltas);
        this.invalidateBounds();
        this.needsCalc = true;
    }

    @Override
    public PointSetIterator iterator() {
        return new ConditionalPointSetIterator();
    }

    @Override
    public int numDimensions() {
        return this.pointSet.numDimensions();
    }

    @Override
    protected long[] findBoundMin() {
        if (this.needsCalc) {
            this.calculator.calc(this);
            this.needsCalc = false;
        }
        return this.calculator.getMin();
    }

    @Override
    protected long[] findBoundMax() {
        if (this.needsCalc) {
            this.calculator.calc(this);
            this.needsCalc = false;
        }
        return this.calculator.getMax();
    }

    @Override
    public boolean includes(long[] point) {
        return this.pointSet.includes(point) && this.condition.isTrue(point);
    }

    @Override
    public long size() {
        long numElements = 0L;
        PointSetIterator iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++numElements;
        }
        return numElements;
    }

    @Override
    public ConditionalPointSet copy() {
        return new ConditionalPointSet(this.pointSet.copy(), this.condition.copy());
    }

    private class ConditionalPointSetIterator
    extends AbstractCursor<long[]>
    implements PointSetIterator {
        private final PointSetIterator iter;
        private long[] curr;
        private long[] nextCache;

        public ConditionalPointSetIterator() {
            super(ConditionalPointSet.this.pointSet.numDimensions());
            this.iter = ConditionalPointSet.this.pointSet.iterator();
            this.reset();
        }

        public boolean hasNext() {
            if (this.nextCache != null) {
                return true;
            }
            return this.positionToNext();
        }

        public void reset() {
            this.iter.reset();
            this.curr = null;
            this.nextCache = null;
        }

        public long[] get() {
            return this.curr;
        }

        public void fwd() {
            if (this.nextCache != null || this.positionToNext()) {
                if (this.curr == null) {
                    this.curr = new long[this.n];
                }
                for (int i = 0; i < this.n; ++i) {
                    this.curr[i] = this.nextCache[i];
                }
                this.nextCache = null;
                return;
            }
            throw new IllegalArgumentException("fwd() cannot go beyond end");
        }

        public void localize(long[] position) {
            for (int i = 0; i < this.n; ++i) {
                position[i] = this.curr[i];
            }
        }

        public long getLongPosition(int d) {
            return this.curr[d];
        }

        public AbstractCursor<long[]> copy() {
            return new ConditionalPointSetIterator();
        }

        public AbstractCursor<long[]> copyCursor() {
            return this.copy();
        }

        private boolean positionToNext() {
            this.nextCache = null;
            while (this.iter.hasNext()) {
                long[] pos = (long[])this.iter.next();
                if (!ConditionalPointSet.this.condition.isTrue(pos)) continue;
                this.nextCache = pos;
                return true;
            }
            return false;
        }
    }
}

