/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ops.pointset;

import java.util.Arrays;
import net.imglib2.ops.parse.PointSetParser;
import net.imglib2.ops.pointset.AbstractPointSet;
import net.imglib2.ops.pointset.EmptyPointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.ops.pointset.PointSetIterator;
import net.imglib2.ops.util.Tuple2;

@Deprecated
public class TextSpecifiedPointSet
extends AbstractPointSet {
    private PointSet set;
    private String origInput;
    private String error;

    public TextSpecifiedPointSet(String specification) {
        this.origInput = specification;
        this.error = null;
        this.set = this.construct(specification);
    }

    @Override
    public long[] getOrigin() {
        return this.set.getOrigin();
    }

    @Override
    public void translate(long[] deltas) {
        this.set.translate(deltas);
        this.invalidateBounds();
    }

    @Override
    public PointSetIterator iterator() {
        return this.set.iterator();
    }

    @Override
    public int numDimensions() {
        return this.set.numDimensions();
    }

    @Override
    protected long[] findBoundMin() {
        long[] min = new long[this.set.numDimensions()];
        this.set.min(min);
        return min;
    }

    @Override
    protected long[] findBoundMax() {
        long[] max = new long[this.set.numDimensions()];
        this.set.max(max);
        return max;
    }

    @Override
    public boolean includes(long[] point) {
        return this.set.includes(point);
    }

    @Override
    public long size() {
        return this.set.size();
    }

    @Override
    public TextSpecifiedPointSet copy() {
        return new TextSpecifiedPointSet(this.origInput);
    }

    public String getErrorString() {
        return this.error;
    }

    private PointSet construct(String spec) {
        PointSetParser parser = new PointSetParser();
        Tuple2<PointSet, String> results = parser.parse(spec);
        if (results.get2() != null) {
            this.error = results.get2();
            return new EmptyPointSet();
        }
        return results.get1();
    }

    public static void main(String[] args) {
        long[] next;
        TextSpecifiedPointSet ps = new TextSpecifiedPointSet("x = [5]");
        System.out.println("result = " + (ps.getErrorString() == null ? "OK" : ps.getErrorString()));
        ps = new TextSpecifiedPointSet("x = [5], y=[1..10]");
        System.out.println("result = " + (ps.getErrorString() == null ? "OK" : ps.getErrorString()));
        ps = new TextSpecifiedPointSet("x= [1..2], y=[ 1, 3 .. 10 ]");
        System.out.println("result = " + (ps.getErrorString() == null ? "OK" : ps.getErrorString()));
        ps = new TextSpecifiedPointSet("xx =[1,4..12] ,yy = [1..5] , xx + yy <= 12");
        System.out.println("result = " + (ps.getErrorString() == null ? "OK" : ps.getErrorString()));
        ps = new TextSpecifiedPointSet("x = [1,7,9], y=[1,4,5]");
        System.out.println("result = " + (ps.getErrorString() == null ? "OK" : ps.getErrorString()));
        System.out.println("Iterate x = [5]");
        ps = new TextSpecifiedPointSet("x = [5]");
        PointSetIterator iter = ps.iterator();
        while (iter.hasNext()) {
            next = (long[])iter.next();
            System.out.println(" " + Arrays.toString(next));
        }
        System.out.println("Iterate x = [1..3], y = [3..5]");
        ps = new TextSpecifiedPointSet("x = [1..3], y = [3..5]");
        iter = ps.iterator();
        while (iter.hasNext()) {
            next = (long[])iter.next();
            System.out.println(" " + Arrays.toString(next));
        }
        System.out.println("Iterate x = [1,3..7], y = [5,8..14]");
        ps = new TextSpecifiedPointSet("x = [1,3..7], y = [5,8..14]");
        iter = ps.iterator();
        while (iter.hasNext()) {
            next = (long[])iter.next();
            System.out.println(" " + Arrays.toString(next));
        }
        System.out.println("Iterate x = [1,4,9], y = [2,3,5,8]");
        ps = new TextSpecifiedPointSet("x = [1,4,9], y = [2,3,5,8]");
        iter = ps.iterator();
        while (iter.hasNext()) {
            next = (long[])iter.next();
            System.out.println(" " + Arrays.toString(next));
        }
        System.out.println("Iterate x = [-2..2], y = [-1,1..5]");
        ps = new TextSpecifiedPointSet("x = [-2..2], y = [-1,1..5]");
        iter = ps.iterator();
        while (iter.hasNext()) {
            next = (long[])iter.next();
            System.out.println(" " + Arrays.toString(next));
        }
        System.out.println("Iterate x=[1..5],y=[1,5..50]");
        ps = new TextSpecifiedPointSet("x=[1..5],y=[1,5..50]");
        iter = ps.iterator();
        while (iter.hasNext()) {
            next = (long[])iter.next();
            System.out.println(" " + Arrays.toString(next));
        }
        System.out.println("Iterate x=[1..20],y=[1..20],x+y < 7");
        ps = new TextSpecifiedPointSet("x=[1..20],y=[1..20],x+y < 7");
        if (ps.getErrorString() != null) {
            System.out.println(ps.getErrorString());
        } else {
            iter = ps.iterator();
            while (iter.hasNext()) {
                next = (long[])iter.next();
                System.out.println(" " + Arrays.toString(next));
            }
        }
        System.out.println("Iterate x=[-5..5],y=[-5..5],x^2+y^2 <= 3");
        ps = new TextSpecifiedPointSet("x=[-5..5],y=[-5..5],x^2+y^2 <= 3");
        if (ps.getErrorString() != null) {
            System.out.println(ps.getErrorString());
        } else {
            iter = ps.iterator();
            while (iter.hasNext()) {
                next = (long[])iter.next();
                System.out.println(" " + Arrays.toString(next));
            }
        }
    }
}

