/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.mesh.io.xyz;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.imagej.mesh.io.PointsIOPlugin;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import org.scijava.io.AbstractIOPlugin;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.FileUtils;

@Plugin(type=PointsIOPlugin.class)
public class XYZPointsIO
extends AbstractIOPlugin<List<RealLocalizable>>
implements PointsIOPlugin {
    private static final String EXTENSION = "xyz";
    @Parameter
    private LogService log;

    public boolean supportsOpen(String source) {
        return FileUtils.getExtension((String)source).toLowerCase().equals(EXTENSION);
    }

    public List<RealLocalizable> open(String source) throws IOException {
        ArrayList<RealLocalizable> points = new ArrayList<RealLocalizable>();
        try (BufferedReader br = new BufferedReader(new FileReader(source));){
            String line;
            while ((line = br.readLine()) != null) {
                double z;
                double y;
                double x;
                if (line.isEmpty() || line.startsWith("#")) continue;
                String[] parts = line.trim().split("[\\s,]+");
                if (parts.length < 3) {
                    this.log.warn((Object)("Invalid line: " + line));
                    continue;
                }
                try {
                    x = Double.parseDouble(parts[0]);
                    y = Double.parseDouble(parts[1]);
                    z = Double.parseDouble(parts[2]);
                }
                catch (NumberFormatException e) {
                    this.log.warn((Object)("Invalid line: " + line));
                    continue;
                }
                points.add((RealLocalizable)new RealPoint(new double[]{x, y, z}));
            }
        }
        return points;
    }
}

