/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TagHoldName
implements ResourceName {
    private static final PathTemplate TAG_VALUE_TAG_HOLD = PathTemplate.createWithoutUrlEncoding((String)"tagValues/{tag_value}/tagHolds/{tag_hold}");
    private volatile Map<String, String> fieldValuesMap;
    private final String tagValue;
    private final String tagHold;

    @Deprecated
    protected TagHoldName() {
        this.tagValue = null;
        this.tagHold = null;
    }

    private TagHoldName(Builder builder) {
        this.tagValue = (String)Preconditions.checkNotNull((Object)builder.getTagValue());
        this.tagHold = (String)Preconditions.checkNotNull((Object)builder.getTagHold());
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public String getTagHold() {
        return this.tagHold;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TagHoldName of(String tagValue, String tagHold) {
        return TagHoldName.newBuilder().setTagValue(tagValue).setTagHold(tagHold).build();
    }

    public static String format(String tagValue, String tagHold) {
        return TagHoldName.newBuilder().setTagValue(tagValue).setTagHold(tagHold).build().toString();
    }

    public static TagHoldName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = TAG_VALUE_TAG_HOLD.validatedMatch(formattedString, "TagHoldName.parse: formattedString not in valid format");
        return TagHoldName.of((String)matchMap.get("tag_value"), (String)matchMap.get("tag_hold"));
    }

    public static List<TagHoldName> parseList(List<String> formattedStrings) {
        ArrayList<TagHoldName> list = new ArrayList<TagHoldName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TagHoldName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TagHoldName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TagHoldName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return TAG_VALUE_TAG_HOLD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TagHoldName tagHoldName = this;
            synchronized (tagHoldName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.tagValue != null) {
                        fieldMapBuilder.put((Object)"tag_value", (Object)this.tagValue);
                    }
                    if (this.tagHold != null) {
                        fieldMapBuilder.put((Object)"tag_hold", (Object)this.tagHold);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return TAG_VALUE_TAG_HOLD.instantiate(new String[]{"tag_value", this.tagValue, "tag_hold", this.tagHold});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TagHoldName that = (TagHoldName)o;
            return Objects.equals(this.tagValue, that.tagValue) && Objects.equals(this.tagHold, that.tagHold);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.tagValue);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tagHold);
    }

    public static class Builder {
        private String tagValue;
        private String tagHold;

        protected Builder() {
        }

        public String getTagValue() {
            return this.tagValue;
        }

        public String getTagHold() {
            return this.tagHold;
        }

        public Builder setTagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public Builder setTagHold(String tagHold) {
            this.tagHold = tagHold;
            return this;
        }

        private Builder(TagHoldName tagHoldName) {
            this.tagValue = tagHoldName.tagValue;
            this.tagHold = tagHoldName.tagHold;
        }

        public TagHoldName build() {
            return new TagHoldName(this);
        }
    }
}

