/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.fft.FFTFunctions;
import mpicbg.imglib.algorithm.fft.FourierTransform;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.ComplexType;
import mpicbg.imglib.type.numeric.RealType;

public class InverseFourierTransform<T extends RealType<T>, S extends ComplexType<S>>
implements MultiThreaded,
OutputAlgorithm<T>,
Benchmark {
    final Image<S> fftImage;
    final int numDimensions;
    Image<T> image;
    T type;
    FourierTransform.Rearrangement rearrangement;
    String errorMessage = "";
    int numThreads;
    long processingTime;
    boolean scale;
    boolean inPlace;
    boolean cropBack;
    int[] originalSize;
    int[] originalOffset;
    float additionalNormalization;

    public InverseFourierTransform(Image<S> fftImage, T type, FourierTransform.Rearrangement rearrangement, boolean inPlace, boolean scale, boolean cropBack, int[] originalSize, int[] originalOffset) {
        this.fftImage = fftImage;
        this.type = type;
        this.numDimensions = fftImage.getNumDimensions();
        this.rearrangement = rearrangement;
        this.scale = scale;
        this.inPlace = inPlace;
        this.cropBack = cropBack;
        this.additionalNormalization = 1.0f;
        if (originalSize != null) {
            this.originalSize = (int[])originalSize.clone();
        }
        if (originalOffset != null) {
            this.originalOffset = (int[])originalOffset.clone();
        }
        this.setNumThreads();
    }

    public InverseFourierTransform(Image<S> fftImage, FourierTransform<T, ?> forwardTransform) {
        this(fftImage, forwardTransform.getImageType(), forwardTransform.getRearrangement(), false, true, true, forwardTransform.getFFTInputSize(), forwardTransform.getFFTInputOffset());
    }

    public InverseFourierTransform(Image<S> fftImage, FourierTransform<?, ?> forwardTransform, T type) {
        this(fftImage, type, forwardTransform.getRearrangement(), false, true, true, forwardTransform.getFFTInputSize(), forwardTransform.getFFTInputOffset());
    }

    public InverseFourierTransform(Image<S> fftImage, T type) {
        this(fftImage, type, FourierTransform.Rearrangement.REARRANGE_QUADRANTS, false, true, false, null, null);
    }

    public void setRearrangement(FourierTransform.Rearrangement rearrangement) {
        this.rearrangement = rearrangement;
    }

    public void setInPlaceTransform(boolean inPlace) {
        this.inPlace = inPlace;
    }

    public void setDoScaling(boolean scale) {
        this.scale = scale;
    }

    public void setCropBackToOriginalSize(boolean cropBack) {
        this.cropBack = cropBack;
    }

    public void setOriginalSize(int[] originalSize) {
        this.originalSize = originalSize;
    }

    public void setOriginalOffset(int[] originalOffset) {
        this.originalOffset = originalOffset;
    }

    public void setAdditionalNormalization(float additionalNormalization) {
        this.additionalNormalization = additionalNormalization;
    }

    public FourierTransform.Rearrangement getRearrangement() {
        return this.rearrangement;
    }

    public boolean getInPlaceTransform() {
        return this.inPlace;
    }

    public boolean getDoScaling() {
        return this.scale;
    }

    public boolean getCropBackToOriginalSize() {
        return this.cropBack;
    }

    public int[] getOriginalSize() {
        return (int[])this.originalSize.clone();
    }

    public int[] getOriginalOffset() {
        return (int[])this.originalOffset.clone();
    }

    public float getAdditionalNormalization() {
        return this.additionalNormalization;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        Object complex = this.inPlace ? this.fftImage : this.fftImage.clone();
        if (this.rearrangement == FourierTransform.Rearrangement.REARRANGE_QUADRANTS) {
            FFTFunctions.rearrangeFFTQuadrants(complex, false, this.getNumThreads());
        }
        this.image = FFTFunctions.computeInverseFFT(complex, this.type, this.getNumThreads(), this.scale, this.cropBack, this.originalSize, this.originalOffset, this.additionalNormalization);
        if (!this.inPlace) {
            ((Image)complex).close();
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public Image<T> getResult() {
        return this.image;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.fftImage == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

