/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.histogram;

import java.util.ArrayList;
import java.util.Hashtable;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.histogram.HistogramBin;
import mpicbg.imglib.algorithm.histogram.HistogramBinFactory;
import mpicbg.imglib.algorithm.histogram.HistogramKey;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.type.Type;

public class Histogram<T extends Type<T>>
implements Algorithm,
Benchmark {
    private long pTime = 0L;
    private Hashtable<HistogramKey<T>, HistogramBin<T>> hashTable;
    private Cursor<T> cursor;
    private final HistogramBinFactory<T> binFactory;

    public Histogram(HistogramBinFactory<T> factory, Cursor<T> c) {
        this.cursor = c;
        this.hashTable = new Hashtable();
        this.binFactory = factory;
    }

    public ArrayList<HistogramKey<T>> getKeys() {
        return new ArrayList<HistogramKey<T>>(this.hashTable.keySet());
    }

    public ArrayList<T> getKeyTypes() {
        ArrayList<HistogramKey<T>> keys = this.getKeys();
        ArrayList<T> types = new ArrayList<T>(keys.size());
        for (HistogramKey<T> hk : keys) {
            types.add(hk.getType());
        }
        return types;
    }

    public HistogramBin<T> getBin(T t) {
        return this.getBin(this.binFactory.createKey(t));
    }

    public HistogramBin<T> getBin(HistogramKey<T> key) {
        if (this.hashTable.containsKey(key)) {
            return this.hashTable.get(key);
        }
        HistogramBin<T> zeroBin = this.binFactory.createBin(key.getType());
        return zeroBin;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        while (this.cursor.hasNext()) {
            this.cursor.fwd();
            HistogramKey<T> key = this.binFactory.createKey(this.cursor.getType());
            HistogramBin<T> bin = this.hashTable.get(key);
            if (bin == null) {
                bin = this.binFactory.createBin(key.getType());
                this.hashTable.put(key, bin);
            }
            bin.inc();
        }
        this.pTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.pTime;
    }
}

