/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.labeling;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.labeling.Labeling;
import mpicbg.imglib.labeling.LabelingType;
import mpicbg.imglib.type.logic.BitType;

public class AllConnectedComponents {
    public static <T extends Comparable<T>> void labelAllConnectedComponents(Labeling<T> labeling, Image<BitType> img, Iterator<T> names) throws NoSuchElementException {
        int[][] offsets = AllConnectedComponents.getStructuringElement(img.getNumDimensions());
        AllConnectedComponents.labelAllConnectedComponents(labeling, img, names, offsets);
    }

    public static <T extends Comparable<T>> void labelAllConnectedComponents(Labeling<T> labeling, Image<BitType> img, Iterator<T> names, int[][] structuringElement) throws NoSuchElementException {
        LocalizableCursor<BitType> c = img.createLocalizableCursor();
        LocalizableByDimCursor<BitType> bc = img.createLocalizableByDimCursor();
        LocalizableByDimCursor destCursor = labeling.createLocalizableByDimCursor();
        int[] srcPosition = img.createPositionArray();
        int[] destPosition = img.createPositionArray();
        int[] dimensions = labeling.getDimensions();
        PositionStack toDoList = new PositionStack(img.getNumDimensions());
        for (BitType t : c) {
            if (!t.get()) continue;
            c.getPosition(srcPosition);
            boolean outOfBounds = false;
            for (int i = 0; i < dimensions.length; ++i) {
                if (srcPosition[i] < dimensions[i]) continue;
                outOfBounds = true;
                break;
            }
            if (outOfBounds) continue;
            destCursor.setPosition(srcPosition);
            if (!((LabelingType)destCursor.getType()).getLabeling().isEmpty()) continue;
            List<Comparable> currentLabel = ((LabelingType)destCursor.getType()).intern((Comparable)names.next());
            ((LabelingType)destCursor.getType()).setLabeling(currentLabel);
            toDoList.push(srcPosition);
            while (!toDoList.isEmpty()) {
                toDoList.pop(srcPosition);
                for (int[] offset : structuringElement) {
                    outOfBounds = false;
                    for (int i = 0; i < offset.length; ++i) {
                        destPosition[i] = srcPosition[i] + offset[i];
                        if (destPosition[i] >= 0 && destPosition[i] < dimensions[i]) continue;
                        outOfBounds = true;
                        break;
                    }
                    if (outOfBounds) continue;
                    bc.setPosition(destPosition);
                    if (!((BitType)bc.getType()).get()) continue;
                    destCursor.setPosition(destPosition);
                    if (!((LabelingType)destCursor.getType()).getLabeling().isEmpty()) continue;
                    ((LabelingType)destCursor.getType()).setLabeling(currentLabel);
                    toDoList.push(destPosition);
                }
            }
        }
        c.close();
        bc.close();
        destCursor.close();
    }

    public static int[][] getStructuringElement(int dimensions) {
        int nElements = 1;
        for (int i = 0; i < dimensions; ++i) {
            nElements *= 3;
        }
        int[][] result = new int[--nElements][dimensions];
        int[] position = new int[dimensions];
        Arrays.fill(position, -1);
        block1: for (int i = 0; i < nElements; ++i) {
            System.arraycopy(position, 0, result[i], 0, dimensions);
            if (i == nElements / 2 - 1) {
                position[0] = position[0] + 2;
                continue;
            }
            for (int j = 0; j < dimensions; ++j) {
                if (position[j] != 1) {
                    int n = j;
                    position[n] = position[n] + 1;
                    continue block1;
                }
                position[j] = -1;
            }
        }
        return result;
    }

    public static Iterator<Integer> getIntegerNames(final int start) {
        return new Iterator<Integer>(){
            int current;
            {
                this.current = start;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Integer next() {
                return this.current++;
            }

            @Override
            public void remove() {
            }
        };
    }

    protected static class PositionStack {
        private final int dimensions;
        private int[] storage;
        private int position = 0;

        public PositionStack(int dimensions) {
            this.dimensions = dimensions;
            this.storage = new int[100 * dimensions];
        }

        public void push(int[] position) {
            int insertPoint = this.position * this.dimensions;
            if (this.storage.length == insertPoint) {
                int[] newStorage = new int[this.storage.length * 3 / 2];
                System.arraycopy(this.storage, 0, newStorage, 0, this.storage.length);
                this.storage = newStorage;
            }
            System.arraycopy(position, 0, this.storage, insertPoint, this.dimensions);
            ++this.position;
        }

        public void pop(int[] position) {
            --this.position;
            System.arraycopy(this.storage, this.position * this.dimensions, position, 0, this.dimensions);
        }

        public boolean isEmpty() {
            return this.position == 0;
        }
    }
}

