/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.peak;

import mpicbg.imglib.algorithm.peak.FitFunction;

public class GaussianMultiDLM
implements FitFunction {
    @Override
    public final double val(double[] x, double[] a) {
        return a[0] * GaussianMultiDLM.E(x, a);
    }

    @Override
    public final double grad(double[] x, double[] a, int k) {
        int ndims = x.length;
        if (k == 0) {
            return GaussianMultiDLM.E(x, a);
        }
        if (k <= ndims) {
            int dim = k - 1;
            return 2.0 * a[dim + ndims] * (x[dim] - a[dim + 1]) * a[0] * GaussianMultiDLM.E(x, a);
        }
        int dim = k - ndims - 1;
        double di = x[dim] - a[dim + 1];
        return -di * di * a[0] * GaussianMultiDLM.E(x, a);
    }

    public final double hessian(double[] x, double[] a, int r, int c) {
        if (c < r) {
            int tmp = c;
            c = r;
            r = tmp;
        }
        int ndims = x.length;
        if (r == 0) {
            if (c == 0) {
                return 0.0;
            }
            if (c <= ndims) {
                int dim = c - 1;
                return 2.0 * a[dim + ndims] * (x[dim] - a[dim + 1]) * GaussianMultiDLM.E(x, a);
            }
            int dim = c - ndims - 1;
            double di = x[dim] - a[dim + 1];
            return -di * di * GaussianMultiDLM.E(x, a);
        }
        if (c == r) {
            if (c <= ndims) {
                int dim = c - 1;
                double di = x[dim] - a[dim + 1];
                return 2.0 * a[0] * GaussianMultiDLM.E(x, a) * a[dim + ndims] * (2.0 * a[dim + ndims] * di * di - 1.0);
            }
            int dim = c - ndims - 1;
            double di = x[dim] - a[dim + 1];
            return a[0] * GaussianMultiDLM.E(x, a) * di * di * di * di;
        }
        if (c <= ndims && r <= ndims) {
            int i = c - 1;
            int j = r - 1;
            double di = x[i] - a[i + 1];
            double dj = x[j] - a[j + 1];
            return 4.0 * a[0] * GaussianMultiDLM.E(x, a) * a[i + ndims] * a[j + ndims] * di * dj;
        }
        if (r <= ndims && c > ndims) {
            int i = r - 1;
            int j = c - ndims - 1;
            double di = x[i] - a[i + 1];
            double dj = x[j] - a[j + 1];
            return -2.0 * a[0] * GaussianMultiDLM.E(x, a) * a[i + ndims] * di * (1.0 - a[j + ndims] * dj * dj);
        }
        int i = r - ndims - 1;
        int j = c - ndims - 1;
        double di = x[i] - a[i + 1];
        double dj = x[j] - a[j + 1];
        return a[0] * GaussianMultiDLM.E(x, a) * di * di * dj * dj;
    }

    private static final double E(double[] x, double[] a) {
        int ndims = x.length;
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            double di = x[i] - a[i + 1];
            sum += a[i + ndims + 1] * di * di;
        }
        return Math.exp(-sum);
    }
}

