/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.roi;

import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.logic.BitType;

public class StructuringElement
extends Image<BitType> {
    private final int[] offset;

    public StructuringElement(int[] dimensions, String name) {
        this(new ImageFactory<BitType>(new BitType(), new ArrayContainerFactory()), dimensions, name);
    }

    public StructuringElement(ImageFactory<BitType> factory, int[] dimensions, String name) {
        super(factory, dimensions, name);
        this.offset = new int[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            this.offset[i] = dimensions[i] / 2;
        }
    }

    public int[] getOffset() {
        return this.offset;
    }

    public static StructuringElement createBall(int nd, double radius) {
        int i;
        int[] dims = new int[nd];
        int[] pos = new int[nd];
        for (i = 0; i < dims.length; ++i) {
            dims[i] = (int)(radius * 2.0 + 1.0);
        }
        StructuringElement strel = new StructuringElement(dims, "Ball Structure " + nd + "D, " + radius);
        LocalizableCursor cursor = strel.createLocalizableCursor();
        while (cursor.hasNext()) {
            double dist = 0.0;
            cursor.fwd();
            cursor.getPosition(pos);
            for (i = 0; i < dims.length; ++i) {
                dist += Math.pow(pos[i] - strel.offset[i], 2.0);
            }
            if ((dist = Math.sqrt(dist)) <= radius) {
                ((BitType)cursor.getType()).setOne();
                continue;
            }
            ((BitType)cursor.getType()).setZero();
        }
        cursor.close();
        strel.removeCursor(cursor);
        return strel;
    }

    public static StructuringElement createCube(int nd, int length) {
        int[] dims = new int[nd];
        for (int i = 0; i < nd; ++i) {
            dims[i] = length;
        }
        StructuringElement strel = new StructuringElement(dims, "Cube Structure " + length);
        Cursor cursor = strel.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            ((BitType)cursor.getType()).setOne();
        }
        cursor.close();
        strel.removeCursor(cursor);
        return strel;
    }

    public static StructuringElement createBar(int nd, int length, int lengthDim) {
        if (lengthDim >= nd) {
            throw new RuntimeException("Invalid bar dimension " + lengthDim + ". Only have " + nd + " dimensions.");
        }
        int[] dims = new int[nd];
        for (int i = 0; i < nd; ++i) {
            dims[i] = i == lengthDim ? length : 1;
        }
        StructuringElement strel = new StructuringElement(dims, "Bar " + lengthDim + " of " + nd + ", " + length);
        Cursor cursor = strel.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            ((BitType)cursor.getType()).setOne();
        }
        cursor.close();
        strel.removeCursor(cursor);
        return strel;
    }
}

