/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container;

import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public abstract class ContainerImpl<T extends Type<T>>
implements Container<T> {
    protected final int numPixels;
    protected final int numDimensions;
    protected final long id;
    protected final int[] dim;
    final ContainerFactory factory;

    public ContainerImpl(ContainerFactory factory, int[] dim) {
        this.numDimensions = dim.length;
        this.numPixels = ContainerImpl.getNumPixels(dim);
        this.dim = (int[])dim.clone();
        this.factory = factory;
        this.id = Image.createUniqueId();
    }

    public static int getNumPixels(int[] dim) {
        int numPixels = 1;
        for (int i = 0; i < dim.length; ++i) {
            numPixels *= dim[i];
        }
        return numPixels;
    }

    @Override
    public ContainerFactory getFactory() {
        return this.factory;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public int getNumDimensions() {
        return this.dim.length;
    }

    @Override
    public int[] getDimensions() {
        return (int[])this.dim.clone();
    }

    @Override
    public void getDimensions(int[] dimensions) {
        for (int i = 0; i < this.numDimensions; ++i) {
            dimensions[i] = this.dim[i];
        }
    }

    @Override
    public int getDimension(int dim) {
        if (dim < this.numDimensions && dim > -1) {
            return this.dim[dim];
        }
        return 1;
    }

    @Override
    public int getNumPixels() {
        return this.numPixels;
    }

    public String toString() {
        String className = this.getClass().getCanonicalName();
        className = className.substring(className.lastIndexOf(".") + 1, className.length());
        String description = className + ", id '" + this.getId() + "' [" + this.dim[0];
        for (int i = 1; i < this.numDimensions; ++i) {
            description = description + "x" + this.dim[i];
        }
        description = description + "]";
        return description;
    }

    @Override
    public boolean compareStorageContainerDimensions(Container<?> container) {
        if (container.getNumDimensions() != this.getNumDimensions()) {
            return false;
        }
        for (int i = 0; i < this.numDimensions; ++i) {
            if (this.dim[i] == container.getDimensions()[i]) continue;
            return false;
        }
        return true;
    }
}

