/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.cell;

import java.util.ArrayList;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.DirectAccessContainerImpl;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.container.cell.Cell;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.cursor.cell.CellCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableByDimCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableCursor;
import mpicbg.imglib.cursor.cell.CellLocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.label.FakeType;

public class CellContainer<T extends Type<T>, A extends ArrayDataAccess<A>>
extends DirectAccessContainerImpl<T, A> {
    protected final ArrayList<Cell<T, A>> data;
    protected final int[] numCellsDim;
    protected final int[] cellSize;
    protected final int numCells;

    public CellContainer(ContainerFactory factory, A creator, int[] dim, int[] cellSize, int entitiesPerPixel) {
        super(factory, dim, entitiesPerPixel);
        for (int d = 0; d < this.getNumDimensions(); ++d) {
            if (cellSize[d] <= dim[d]) continue;
            cellSize[d] = dim[d];
        }
        this.cellSize = cellSize;
        this.numCellsDim = new int[this.getNumDimensions()];
        int tmp = 1;
        for (int d = 0; d < this.getNumDimensions(); ++d) {
            this.numCellsDim[d] = (dim[d] - 1) / cellSize[d] + 1;
            tmp *= this.numCellsDim[d];
        }
        this.numCells = tmp;
        this.data = this.createCellArray(this.numCells);
        ArrayLocalizableCursor<FakeType> cursor = ArrayLocalizableCursor.createLinearCursor(this.numCellsDim);
        for (int c = 0; c < this.numCells; ++c) {
            cursor.fwd();
            int[] finalSize = new int[this.getNumDimensions()];
            int[] finalOffset = new int[this.getNumDimensions()];
            for (int d = 0; d < this.getNumDimensions(); ++d) {
                finalSize[d] = cellSize[d];
                if (cursor.getPosition(d) == this.numCellsDim[d] - 1 && dim[d] % cellSize[d] != 0) {
                    finalSize[d] = dim[d] % cellSize[d];
                }
                finalOffset[d] = cursor.getPosition(d) * cellSize[d];
            }
            this.data.add(this.createCellInstance(creator, c, finalSize, finalOffset, entitiesPerPixel));
        }
        cursor.close();
    }

    @Override
    public A update(Cursor<?> c) {
        return this.data.get(c.getStorageIndex()).getData();
    }

    public ArrayList<Cell<T, A>> createCellArray(int numCells) {
        return new ArrayList<Cell<T, A>>(numCells);
    }

    public Cell<T, A> createCellInstance(A creator, int cellId, int[] dim, int[] offset, int entitiesPerPixel) {
        return new Cell(creator, cellId, dim, offset, entitiesPerPixel);
    }

    public Cell<T, A> getCell(int cellId) {
        return this.data.get(cellId);
    }

    public int getCellIndex(ArrayLocalizableByDimCursor<FakeType> cursor, int[] cellPos) {
        cursor.setPosition(cellPos);
        return cursor.getArrayIndex();
    }

    public int getCellIndex(ArrayLocalizableByDimCursor<FakeType> cursor, int cellPos, int dim) {
        cursor.setPosition(cellPos, dim);
        return cursor.getArrayIndex();
    }

    public int[] getCellPosition(int[] position) {
        int[] cellPos = new int[position.length];
        for (int d = 0; d < this.numDimensions; ++d) {
            cellPos[d] = position[d] / this.cellSize[d];
        }
        return cellPos;
    }

    public void getCellPosition(int[] position, int[] cellPos) {
        for (int d = 0; d < this.numDimensions; ++d) {
            cellPos[d] = position[d] / this.cellSize[d];
        }
    }

    public int getCellPosition(int position, int dim) {
        return position / this.cellSize[dim];
    }

    public int getCellIndexFromImageCoordinates(ArrayLocalizableByDimCursor<FakeType> cursor, int[] position) {
        return this.getCellIndex(cursor, this.getCellPosition(position));
    }

    public int getNumCells(int dim) {
        if (dim < this.numDimensions) {
            return this.numCellsDim[dim];
        }
        return 1;
    }

    public int getNumCells() {
        return this.numCells;
    }

    public int[] getNumCellsDim() {
        return (int[])this.numCellsDim.clone();
    }

    public int getCellSize(int dim) {
        return this.cellSize[dim];
    }

    public int[] getCellSize() {
        return (int[])this.cellSize.clone();
    }

    @Override
    public void close() {
        for (Cell<T, A> e : this.data) {
            e.close();
        }
    }

    @Override
    public CellCursor<T> createCursor(Image<T> image) {
        CellCursor<T> c = new CellCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return c;
    }

    @Override
    public CellLocalizableCursor<T> createLocalizableCursor(Image<T> image) {
        CellLocalizableCursor<T> c = new CellLocalizableCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return c;
    }

    @Override
    public CellLocalizablePlaneCursor<T> createLocalizablePlaneCursor(Image<T> image) {
        CellLocalizablePlaneCursor<T> c = new CellLocalizablePlaneCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return c;
    }

    @Override
    public CellLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        CellLocalizableByDimCursor<T> c = new CellLocalizableByDimCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        return c;
    }

    @Override
    public CellLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        CellLocalizableByDimOutOfBoundsCursor<T> c = new CellLocalizableByDimOutOfBoundsCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer(), outOfBoundsFactory);
        return c;
    }

    @Override
    public boolean compareStorageContainerCompatibility(Container<?> container) {
        if (this.compareStorageContainerDimensions(container)) {
            if (this.getFactory().getClass().isInstance(container.getFactory())) {
                CellContainer otherCellContainer = (CellContainer)container;
                for (int d = 0; d < this.numDimensions; ++d) {
                    if (this.getCellSize(d) == otherCellContainer.getCellSize(d)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

