/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.imageplus;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.container.imageplus.ImagePlusContainer;
import mpicbg.imglib.container.imageplus.ImagePlusContainerFactory;
import mpicbg.imglib.exception.ImgLibException;
import mpicbg.imglib.type.Type;

public class IntImagePlus<T extends Type<T>>
extends ImagePlusContainer<T, IntArray> {
    protected final ImagePlus imp;

    public IntImagePlus(ImagePlusContainerFactory factory, int[] dim, int entitiesPerPixel) {
        super(factory, dim, entitiesPerPixel);
        this.mirror.clear();
        if (entitiesPerPixel == 1) {
            ImageStack stack = new ImageStack(this.width, this.height);
            for (int i = 0; i < this.slices; ++i) {
                stack.addSlice("", (ImageProcessor)new ColorProcessor(this.width, this.height));
            }
            this.imp = new ImagePlus("image", stack);
            this.imp.setDimensions(this.channels, this.depth, this.frames);
            if (this.slices > 1) {
                this.imp.setOpenAsHyperStack(true);
            }
            for (int t = 0; t < this.frames; ++t) {
                for (int z = 0; z < this.depth; ++z) {
                    for (int c = 0; c < this.channels; ++c) {
                        this.mirror.add(new IntArray((int[])this.imp.getStack().getPixels(this.imp.getStackIndex(c + 1, z + 1, t + 1))));
                    }
                }
            }
        } else {
            this.imp = null;
            for (int i = 0; i < this.slices; ++i) {
                this.mirror.add(new IntArray(this.width * this.height * entitiesPerPixel));
            }
        }
    }

    public IntImagePlus(ImagePlus imp, ImagePlusContainerFactory factory) {
        super(factory, imp.getWidth(), imp.getHeight(), imp.getNSlices(), imp.getNFrames(), imp.getNChannels(), 1);
        this.imp = imp;
        this.mirror.clear();
        for (int t = 0; t < this.frames; ++t) {
            for (int z = 0; z < this.depth; ++z) {
                for (int c = 0; c < this.channels; ++c) {
                    this.mirror.add(new IntArray((int[])imp.getStack().getProcessor(imp.getStackIndex(c + 1, z + 1, t + 1)).getPixels()));
                }
            }
        }
    }

    @Override
    public void setPlane(int no, IntArray plane) {
        System.arraycopy(plane.getCurrentStorageArray(), 0, ((IntArray)this.mirror.get(no)).getCurrentStorageArray(), 0, plane.getCurrentStorageArray().length);
    }

    @Override
    public void close() {
        super.close();
        if (this.imp != null) {
            this.imp.close();
        }
    }

    @Override
    public ImagePlus getImagePlus() throws ImgLibException {
        if (this.imp == null) {
            throw new ImgLibException(this, "has no ImagePlus instance, it is not a standard type of ImagePlus (" + this.entitiesPerPixel + " entities per pixel)");
        }
        return this.imp;
    }
}

