/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array3D;
import mpicbg.imglib.cursor.LocalizableCursor3D;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class Array3DLocalizableCursor<T extends Type<T>>
extends ArrayLocalizableCursor<T>
implements LocalizableCursor3D<T> {
    protected int x = -1;
    protected int y = 0;
    protected int z = 0;
    final int widthMinus1;
    final int heightMinus1;
    final int depthMinus1;
    final int width;
    final int height;
    final int depth;
    final Array3D<T, ?> container;

    public Array3DLocalizableCursor(Array3D<T, ?> container, Image<T> image, T type) {
        super(container, image, type);
        this.container = container;
        this.width = container.getWidth();
        this.height = container.getHeight();
        this.depth = container.getDepth();
        this.widthMinus1 = this.width - 1;
        this.heightMinus1 = this.height - 1;
        this.depthMinus1 = this.depth - 1;
    }

    @Override
    public void fwd() {
        this.type.incIndex();
        if (this.x < this.widthMinus1) {
            ++this.x;
        } else if (this.y < this.heightMinus1) {
            this.x = 0;
            ++this.y;
        } else {
            this.x = 0;
            this.y = 0;
            ++this.z;
        }
    }

    @Override
    public void fwd(long steps) {
        if (steps <= 0L) {
            return;
        }
        this.type.incIndex((int)steps);
        int i = this.type.getIndex();
        this.z = i / (this.width * this.height);
        this.y = (i -= this.z * this.width * this.height) / this.width;
        this.x = i -= this.y * this.width;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public void reset() {
        this.isClosed = false;
        this.x = -1;
        this.z = 0;
        this.y = 0;
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
    }

    @Override
    public void getPosition(int[] position) {
        position[0] = this.x;
        position[1] = this.y;
        position[2] = this.z;
    }

    @Override
    public Array3D<T, ?> getStorageContainer() {
        return this.container;
    }

    @Override
    public int[] getPosition() {
        return new int[]{this.x, this.y, this.z};
    }

    @Override
    public int getPosition(int dim) {
        if (dim == 0) {
            return this.x;
        }
        if (dim == 1) {
            return this.y;
        }
        if (dim == 2) {
            return this.z;
        }
        System.err.println("Array3DLocalizableCursor.getPosition( int dim ): There is no dimension " + dim);
        return -1;
    }

    @Override
    public String getPositionAsString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

