/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.cell;

import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.cell.CellCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class CellLocalizableCursor<T extends Type<T>>
extends CellCursor<T>
implements LocalizableCursor<T> {
    protected final int numDimensions;
    protected final int[] position;
    protected final int[] dimensions;
    protected final int[] cellDimensions;
    protected final int[] cellOffset;

    public CellLocalizableCursor(CellContainer<T, ?> container, Image<T> image, T type) {
        super(container, image, type);
        this.numDimensions = container.getNumDimensions();
        this.position = new int[this.numDimensions];
        this.dimensions = container.getDimensions();
        this.cellDimensions = new int[this.numDimensions];
        this.cellOffset = new int[this.numDimensions];
        this.reset();
    }

    @Override
    protected void getCellData(int cell) {
        if (cell == this.lastCell) {
            return;
        }
        this.lastCell = cell;
        this.cellInstance = this.container.getCell(cell);
        this.cellMaxI = this.cellInstance.getNumPixels();
        this.cellInstance.getDimensions(this.cellDimensions);
        this.cellInstance.getOffset(this.cellOffset);
        this.type.updateContainer(this);
    }

    @Override
    public void reset() {
        if (this.position == null) {
            return;
        }
        this.type.updateIndex(-1);
        this.cell = 0;
        this.getCellData(this.cell);
        this.isClosed = false;
        this.position[0] = -1;
        for (int d = 1; d < this.numDimensions; ++d) {
            this.position[d] = 0;
        }
        this.type.updateContainer(this);
    }

    @Override
    public void fwd() {
        if (this.type.getIndex() < this.cellMaxI - 1) {
            this.type.incIndex();
            for (int d = 0; d < this.numDimensions; ++d) {
                if (this.position[d] >= this.cellDimensions[d] + this.cellOffset[d] - 1) continue;
                int n = d;
                this.position[n] = this.position[n] + 1;
                for (int e = 0; e < d; ++e) {
                    this.position[e] = this.cellOffset[e];
                }
                break;
            }
        } else if (this.cell < this.numCells - 1) {
            ++this.cell;
            this.type.updateIndex(0);
            this.getCellData(this.cell);
            for (int d = 0; d < this.numDimensions; ++d) {
                this.position[d] = this.cellOffset[d];
            }
        } else {
            this.lastCell = -1;
            this.type.updateIndex(this.cellMaxI);
            this.cell = this.numCells;
        }
    }

    @Override
    public void getPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            position[d] = this.position[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.position[dim];
    }

    @Override
    public String getPositionAsString() {
        String pos = "(" + this.position[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            pos = pos + ", " + this.position[d];
        }
        pos = pos + ")";
        return pos;
    }

    @Override
    public String toString() {
        return this.getPositionAsString() + " = " + this.getType();
    }
}

