/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.planar;

import mpicbg.imglib.container.planar.PlanarContainer;
import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class PlanarCursor<T extends Type<T>>
extends CursorImpl<T> {
    protected final T type;
    protected final PlanarContainer<T, ?> container;
    protected final int lastIndex;
    protected final int lastSliceIndex;
    protected int sliceIndex;
    protected boolean hasNext;

    public PlanarCursor(PlanarContainer<T, ?> container, Image<T> image, T type) {
        super(container, image);
        this.type = type;
        this.container = container;
        this.lastIndex = container.getDimension(0) * container.getDimension(1) - 1;
        this.lastSliceIndex = container.getSlices() - 1;
        this.reset();
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void fwd() {
        this.type.incIndex();
        int i = this.type.getIndex();
        if (i < this.lastIndex) {
            return;
        }
        if (i == this.lastIndex) {
            this.hasNext = this.sliceIndex < this.lastSliceIndex;
        } else {
            ++this.sliceIndex;
            this.type.updateIndex(0);
            this.type.updateContainer(this);
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.type.updateIndex(this.lastIndex + 1);
        this.sliceIndex = this.lastSliceIndex + 1;
    }

    @Override
    public void reset() {
        this.sliceIndex = 0;
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
        this.isClosed = false;
        this.hasNext = true;
    }

    public PlanarContainer<T, ?> getStorageContainer() {
        return this.container;
    }

    @Override
    public int getStorageIndex() {
        return this.sliceIndex;
    }

    public String toString() {
        return this.type.toString();
    }
}

