/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.special;

import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.special.DomainCursor;
import mpicbg.imglib.cursor.special.Utils;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.numeric.RealType;

public final class DiscCursor<T extends RealType<T>>
extends DomainCursor<T> {
    private CursorState state;
    private CursorState nextState;
    private int rx;
    private int[] rxs;
    private boolean allDone;

    public DiscCursor(Image<T> img, float[] center, float radius, float[] calibration, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        this.img = img;
        this.size = radius;
        this.cursor = img.createLocalizableByDimCursor(outOfBoundsFactory);
        this.calibration = null == calibration ? new float[]{1.0f, 1.0f, 1.0f} : (float[])calibration.clone();
        this.origin = new int[img.getNumDimensions()];
        for (int i = 0; i < this.origin.length; ++i) {
            this.origin[i] = Math.round(center[i] / this.calibration[i]);
        }
        this.rxs = new int[(int)(Math.max(Math.ceil(radius / this.calibration[0]), Math.ceil(radius / this.calibration[1])) + 1.0)];
        this.reset();
    }

    public DiscCursor(Image<T> img, float[] center, float radius, float[] calibration) {
        this(img, center, radius, calibration, new OutOfBoundsStrategyValueFactory());
    }

    public DiscCursor(Image<T> img, float[] center, float radius) {
        this(img, center, radius, img.getCalibration());
    }

    public DiscCursor(Image<T> img, Localizable centerCursor, float radius, float[] calibration, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        this.img = img;
        this.size = radius;
        this.cursor = img.createLocalizableByDimCursor(outOfBoundsFactory);
        this.calibration = null == calibration ? new float[]{1.0f, 1.0f, 1.0f} : (float[])calibration.clone();
        this.origin = centerCursor.getPosition();
        this.rxs = new int[Math.max(Math.round(radius / calibration[0]), Math.round(radius / calibration[1])) + 1];
        this.reset();
    }

    public DiscCursor(Image<T> img, Localizable centerCursor, float radius, float[] calibration) {
        this(img, centerCursor, radius, calibration, new OutOfBoundsStrategyValueFactory());
    }

    public DiscCursor(Image<T> img, Localizable centerCursor, float radius) {
        this(img, centerCursor, radius, img.getCalibration(), new OutOfBoundsStrategyValueFactory());
    }

    @Override
    public void setSize(float size) {
        this.size = size;
        this.rxs = new int[Math.max(Math.round(size / this.calibration[0]), Math.round(size / this.calibration[1])) + 1];
        this.reset();
    }

    @Override
    public int getNPixels() {
        int pixel_count = 0;
        int[] local_rxs = new int[Math.max(Math.round(this.size / this.calibration[1]), Math.round(this.size / this.calibration[0])) + 1];
        Utils.getXYEllipseBounds(Math.round(this.size / this.calibration[0]), Math.round(this.size / this.calibration[1]), local_rxs);
        pixel_count += 2 * local_rxs[0] + 1;
        for (int i = 1; i <= Math.round(this.size / this.calibration[1]); ++i) {
            int local_rx = local_rxs[i];
            pixel_count += 2 * (2 * local_rx + 1);
        }
        return pixel_count;
    }

    public final double getPhi() {
        return Math.atan2((float)this.position[1] * this.calibration[1], (float)this.position[0] * this.calibration[0]);
    }

    @Override
    public void reset() {
        this.cursor.reset();
        this.state = CursorState.INITIALIZED;
        this.position = new int[this.img.getNumDimensions()];
        this.hasNext = true;
        this.allDone = false;
    }

    @Override
    public void fwd() {
        switch (this.state) {
            case DRAWING_LINE: {
                this.cursor.fwd(0);
                this.position[0] = this.position[0] + 1;
                if (this.position[0] < this.rx) break;
                this.state = this.nextState;
                if (!this.allDone) break;
                this.hasNext = false;
                break;
            }
            case INITIALIZED: {
                Utils.getXYEllipseBounds(Math.round(this.size / this.calibration[0]), Math.round(this.size / this.calibration[1]), this.rxs);
                this.rx = this.rxs[0];
                this.cursor.setPosition(this.origin);
                this.cursor.setPosition(this.origin[0] - this.rx, 0);
                this.position[0] = -this.rx;
                this.state = CursorState.DRAWING_LINE;
                this.nextState = CursorState.INCREMENT_Y;
                break;
            }
            case INCREMENT_Y: {
                this.position[1] = -this.position[1] + 1;
                this.rx = this.rxs[this.position[1]];
                this.cursor.setPosition(this.origin[1] + this.position[1], 1);
                this.position[0] = -this.rx;
                this.cursor.setPosition(this.origin[0] - this.rx, 0);
                this.nextState = CursorState.MIRROR_Y;
                if (this.rx == 0) {
                    this.state = CursorState.MIRROR_Y;
                    break;
                }
                this.state = CursorState.DRAWING_LINE;
                break;
            }
            case MIRROR_Y: {
                this.position[0] = -this.rx;
                this.position[1] = -this.position[1];
                this.cursor.setPosition(this.origin[1] + this.position[1], 1);
                this.cursor.setPosition(this.origin[0] - this.rx, 0);
                if (this.position[1] <= -Math.round(this.size / this.calibration[1])) {
                    this.allDone = true;
                } else {
                    this.nextState = CursorState.INCREMENT_Y;
                }
                if (this.rx == 0) {
                    if (this.allDone) {
                        this.hasNext = false;
                        break;
                    }
                    this.state = this.nextState;
                    break;
                }
                this.state = CursorState.DRAWING_LINE;
            }
        }
    }

    private static enum CursorState {
        DRAWING_LINE,
        INITIALIZED,
        INCREMENT_Y,
        MIRROR_Y;

    }
}

