/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.special;

import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.special.DomainCursor;
import mpicbg.imglib.cursor.special.Utils;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.Type;

public final class SphereCursor<T extends Type<T>>
extends DomainCursor<T> {
    private CursorState state;
    private CursorState nextState;
    private boolean mirrorZ;
    private int rx;
    private int ry;
    private int[] rys;
    private int[] rxs;
    private boolean doneZ;
    private boolean allDone;

    public SphereCursor(Image<T> img, float[] center, float radius, float[] calibration, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        this.doneZ = false;
        if (img.getDimensions().length != 3) {
            throw new IllegalArgumentException(String.format("SphereCursor: must get a 3D image, got a %dD image.", img.getDimensions().length));
        }
        this.img = img;
        this.size = radius;
        this.cursor = img.createLocalizableByDimCursor(outOfBoundsFactory);
        this.calibration = null == calibration ? new float[]{1.0f, 1.0f, 1.0f} : (float[])calibration.clone();
        this.origin = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.origin[i] = Math.round(center[i] / calibration[i]);
        }
        this.rxs = new int[(int)(Math.max(Math.ceil(radius / this.calibration[1]), Math.ceil(radius / this.calibration[0])) + 1.0)];
        this.rys = new int[(int)(Math.ceil(radius / this.calibration[2]) + 1.0)];
        this.reset();
    }

    public SphereCursor(Image<T> img, float[] center, float radius, float[] calibration) {
        this(img, center, radius, calibration, new OutOfBoundsStrategyValueFactory());
    }

    public SphereCursor(Image<T> img, double[] center, double radius, double[] calibration) {
        float[] fArray;
        float[] fArray2 = new float[]{(float)center[0], (float)center[1], (float)center[2]};
        float f = (float)radius;
        if (null == calibration) {
            fArray = null;
        } else {
            float[] fArray3 = new float[3];
            fArray3[0] = (float)calibration[0];
            fArray3[1] = (float)calibration[1];
            fArray = fArray3;
            fArray3[2] = (float)calibration[2];
        }
        this(img, fArray2, f, fArray);
    }

    public SphereCursor(Image<T> img, float[] center, float radius) {
        this(img, center, radius, img.getCalibration());
    }

    public SphereCursor(Image<T> img, double[] center, double radius) {
        this(img, new float[]{(float)center[0], (float)center[1], (float)center[2]}, (float)radius, img.getCalibration());
    }

    public SphereCursor(Image<T> img, Localizable centerCursor, float radius, float[] calibration, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        this.doneZ = false;
        if (img.getDimensions().length != 3) {
            throw new IllegalArgumentException(String.format("SphereCursor: must get a 3D image, got a %dD image.", img.getDimensions().length));
        }
        this.img = img;
        this.size = radius;
        this.cursor = img.createLocalizableByDimCursor(outOfBoundsFactory);
        this.calibration = null == calibration ? new float[]{1.0f, 1.0f, 1.0f} : (float[])calibration.clone();
        this.origin = centerCursor.getPosition();
        this.rxs = new int[Math.max(Math.round(radius / calibration[1]), Math.round(radius / calibration[0])) + 1];
        this.rys = new int[Math.round(radius / calibration[2]) + 1];
        this.reset();
    }

    public SphereCursor(Image<T> img, Localizable centerCursor, float radius, float[] calibration) {
        this(img, centerCursor, radius, calibration, new OutOfBoundsStrategyValueFactory());
    }

    public SphereCursor(Image<T> img, Localizable centerCursor, float radius) {
        this(img, centerCursor, radius, img.getCalibration(), new OutOfBoundsStrategyValueFactory());
    }

    @Override
    public int getNPixels() {
        int pixel_count = 0;
        int nzplanes = Math.round(this.size / this.calibration[0]);
        int[] local_rys = new int[nzplanes + 1];
        int[] local_rxs = new int[Math.max(Math.round(this.size / this.calibration[1]), Math.round(this.size / this.calibration[0])) + 1];
        Utils.getXYEllipseBounds(Math.round(this.size / this.calibration[1]), Math.round(this.size / this.calibration[2]), local_rys);
        Utils.getXYEllipseBounds(Math.round(this.size / this.calibration[0]), Math.round(this.size / this.calibration[1]), local_rxs);
        int local_ry = local_rys[0];
        int local_rx = local_rxs[0];
        pixel_count += 2 * local_rx + 1;
        for (int i = 1; i <= local_ry; ++i) {
            local_rx = local_rxs[i];
            pixel_count += 2 * (2 * local_rx + 1);
        }
        for (int j = 1; j <= nzplanes; ++j) {
            local_ry = local_rys[j];
            if (local_ry == 0) continue;
            Utils.getXYEllipseBounds(Math.round((float)local_ry * this.calibration[1] / this.calibration[0]), local_ry, local_rxs);
            local_rx = local_rxs[0];
            pixel_count += 2 * (2 * local_rx + 1);
            for (int i = 1; i <= local_ry; ++i) {
                local_rx = local_rxs[i];
                pixel_count += 4 * (2 * local_rx + 1);
            }
        }
        return pixel_count;
    }

    @Override
    public void setSize(float size) {
        this.size = size;
        this.rxs = new int[Math.max(Math.round(size / this.calibration[1]), Math.round(size / this.calibration[0])) + 1];
        this.rys = new int[Math.round(size / this.calibration[2]) + 1];
        this.reset();
    }

    public final double getTheta() {
        return Math.acos((double)((float)this.position[2] * this.calibration[2]) / Math.sqrt(this.getDistanceSquared()));
    }

    public final double getPhi() {
        return Math.atan2((float)this.position[1] * this.calibration[1], (float)this.position[0] * this.calibration[0]);
    }

    @Override
    public final void fwd() {
        switch (this.state) {
            case DRAWING_LINE: {
                this.cursor.fwd(0);
                this.position[0] = this.position[0] + 1;
                if (this.position[0] < this.rx) break;
                this.state = this.nextState;
                if (!this.allDone) break;
                this.hasNext = false;
                break;
            }
            case INITIALIZED: {
                Utils.getXYEllipseBounds(Math.round(this.size / this.calibration[1]), Math.round(this.size / this.calibration[2]), this.rys);
                this.ry = this.rys[0];
                Utils.getXYEllipseBounds(Math.round(this.size / this.calibration[0]), Math.round(this.size / this.calibration[1]), this.rxs);
                this.rx = this.rxs[0];
                this.cursor.setPosition(this.origin[0] - this.rx, 0);
                this.cursor.setPosition(this.origin[1], 1);
                this.cursor.setPosition(this.origin[2], 2);
                this.position[0] = -this.rx;
                this.state = CursorState.DRAWING_LINE;
                this.nextState = CursorState.INCREMENT_Y;
                break;
            }
            case INCREMENT_Y: {
                this.position[1] = -this.position[1] + 1;
                this.rx = this.rxs[this.position[1]];
                this.cursor.setPosition(this.origin[1] + this.position[1], 1);
                this.position[0] = -this.rx;
                this.cursor.setPosition(this.origin[0] - this.rx, 0);
                this.nextState = CursorState.MIRROR_Y;
                if (this.rx == 0) {
                    this.state = CursorState.MIRROR_Y;
                    break;
                }
                this.state = CursorState.DRAWING_LINE;
                break;
            }
            case MIRROR_Y: {
                this.position[0] = -this.rx;
                this.position[1] = -this.position[1];
                this.cursor.setPosition(this.origin[1] + this.position[1], 1);
                this.cursor.setPosition(this.origin[0] - this.rx, 0);
                if (this.position[1] <= -this.ry) {
                    if (this.doneZ) {
                        this.allDone = true;
                    } else {
                        this.nextState = CursorState.INCREMENT_Z;
                    }
                } else {
                    this.nextState = CursorState.INCREMENT_Y;
                }
                if (this.rx == 0) {
                    if (this.allDone) {
                        this.hasNext = false;
                        break;
                    }
                    this.state = this.nextState;
                    break;
                }
                this.state = CursorState.DRAWING_LINE;
                break;
            }
            case INCREMENT_Z: {
                if (this.mirrorZ) {
                    this.position[2] = -this.position[2];
                    this.mirrorZ = false;
                    if (this.position[2] <= -Math.round(this.size / this.calibration[2])) {
                        this.doneZ = true;
                    }
                } else {
                    this.position[2] = -this.position[2] + 1;
                    this.ry = this.rys[this.position[2]];
                    this.mirrorZ = true;
                }
                Utils.getXYEllipseBounds(Math.round((float)this.ry * this.calibration[1] / this.calibration[0]), this.ry, this.rxs);
                this.rx = this.rxs[0];
                this.cursor.setPosition(this.origin[0] - this.rx, 0);
                this.cursor.setPosition(this.origin[1], 1);
                this.cursor.setPosition(this.origin[2] + this.position[2], 2);
                this.position[0] = -this.rx;
                this.position[1] = 0;
                this.state = CursorState.DRAWING_LINE;
                this.nextState = CursorState.INCREMENT_Y;
            }
        }
    }

    @Override
    public final void reset() {
        this.cursor.reset();
        this.state = CursorState.INITIALIZED;
        this.mirrorZ = false;
        this.doneZ = false;
        this.allDone = false;
        this.position = new int[3];
        this.hasNext = true;
    }

    private static enum CursorState {
        DRAWING_LINE,
        INITIALIZED,
        INCREMENT_Y,
        MIRROR_Y,
        INCREMENT_Z;

    }
}

