/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.logic;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.BitAccess;
import mpicbg.imglib.container.basictypecontainer.array.BitArray;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.BitTypeDisplay;
import mpicbg.imglib.type.BooleanType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.IntegerTypeImpl;

public class BitType
extends IntegerTypeImpl<BitType>
implements BooleanType<BitType>,
RealType<BitType> {
    final DirectAccessContainer<BitType, ? extends BitAccess> storage;
    BitAccess b;

    public BitType(DirectAccessContainer<BitType, ? extends BitAccess> bitStorage) {
        this.storage = bitStorage;
    }

    public BitType(boolean value) {
        this.storage = null;
        this.b = new BitArray(1);
        this.b.setValue(this.i, value);
    }

    public BitType() {
        this(false);
    }

    @Override
    public DirectAccessContainer<BitType, ? extends BitAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory storageFactory, int[] dim) {
        DirectAccessContainer<BitType, BitAccess> container = storageFactory.createBitInstance(dim, 1);
        BitType linkedType = new BitType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public void updateContainer(Cursor<?> c) {
        this.b = this.storage.update(c);
    }

    @Override
    public BitType duplicateTypeOnSameDirectAccessContainer() {
        return new BitType(this.storage);
    }

    public BitTypeDisplay getDefaultDisplay(Image<BitType> image) {
        return new BitTypeDisplay(image);
    }

    @Override
    public boolean get() {
        return this.b.getValue(this.i);
    }

    @Override
    public void set(boolean value) {
        this.b.setValue(this.i, value);
    }

    @Override
    public int getInteger() {
        return this.get() ? 1 : 0;
    }

    @Override
    public long getIntegerLong() {
        return this.get() ? 1L : 0L;
    }

    @Override
    public void setInteger(int f) {
        if (f >= 1) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public void setInteger(long f) {
        if (f >= 1L) {
            this.set(true);
        } else {
            this.set(false);
        }
    }

    @Override
    public double getMaxValue() {
        return 1.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void set(BitType c) {
        this.b.setValue(this.i, c.get());
    }

    @Override
    public void and(BitType c) {
        this.b.setValue(this.i, this.b.getValue(this.i) && c.get());
    }

    @Override
    public void or(BitType c) {
        this.b.setValue(this.i, this.b.getValue(this.i) || c.get());
    }

    @Override
    public void xor(BitType c) {
        this.b.setValue(this.i, this.b.getValue(this.i) ^ c.get());
    }

    @Override
    public void not() {
        this.b.setValue(this.i, !this.b.getValue(this.i));
    }

    @Override
    public void add(BitType c) {
        this.xor(c);
    }

    @Override
    public void div(BitType c) {
        this.and(c);
    }

    @Override
    public void mul(BitType c) {
        this.and(c);
    }

    @Override
    public void sub(BitType c) {
        this.xor(c);
    }

    @Override
    public void mul(float c) {
        if (c >= 0.5f) {
            this.b.setValue(this.i, this.b.getValue(this.i));
        } else {
            if (this.b.getValue(this.i)) {
                // empty if block
            }
            this.b.setValue(this.i, false);
        }
    }

    @Override
    public void mul(double c) {
        if (c >= 0.5) {
            this.b.setValue(this.i, this.b.getValue(this.i));
        } else {
            if (this.b.getValue(this.i)) {
                // empty if block
            }
            this.b.setValue(this.i, false);
        }
    }

    @Override
    public void setOne() {
        this.b.setValue(this.i, true);
    }

    @Override
    public void setZero() {
        this.b.setValue(this.i, false);
    }

    @Override
    public void inc() {
        this.b.setValue(this.i, !this.b.getValue(this.i));
    }

    @Override
    public void dec() {
        this.inc();
    }

    @Override
    public int compareTo(BitType c) {
        boolean b1 = this.b.getValue(this.i);
        boolean b2 = c.get();
        if (b1 && !b2) {
            return 1;
        }
        if (!b1 && b2) {
            return -1;
        }
        return 0;
    }

    public BitType[] createArray1D(int size1) {
        return new BitType[size1];
    }

    public BitType[][] createArray2D(int size1, int size2) {
        return new BitType[size1][size2];
    }

    public BitType[][][] createArray3D(int size1, int size2, int size3) {
        return new BitType[size1][size2][size3];
    }

    @Override
    public BitType createVariable() {
        return new BitType();
    }

    @Override
    public BitType copy() {
        return new BitType(this.b.getValue(this.i));
    }

    @Override
    public String toString() {
        boolean value = this.b.getValue(this.i);
        if (value) {
            return "1";
        }
        return "0";
    }
}

