/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.gauss.DownSample;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

public class Downsample<T extends RealType<T>>
extends Image<T> {
    public Downsample(IFunction fn, float factor) throws Exception {
        this(Compute.inFloats(fn), factor);
    }

    public Downsample(Image<T> img, float factor) throws Exception {
        super(Downsample.create(img, factor).getContainer(), img.createType(), "Downsampled");
    }

    private static final <R extends RealType<R>> Image<R> create(Image<R> img, float factor) throws Exception {
        DownSample<R> ds = new DownSample<R>(img, factor);
        if (!ds.checkInput() || !ds.process()) {
            throw new Exception("Downsampling error: " + ds.getErrorMessage());
        }
        return ds.getResult();
    }
}

