/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm.fn;

import mpicbg.imglib.algorithm.transformation.ImageTransform;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.linear.LinearInterpolatorFactory;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolatorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyValueFactory;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import script.imglib.color.Alpha;
import script.imglib.color.Blue;
import script.imglib.color.Green;
import script.imglib.color.RGBA;
import script.imglib.color.Red;
import script.imglib.math.Compute;

public abstract class AbstractAffine3D<T extends NumericType<T>>
extends Image<T> {
    public static final Mode LINEAR = Mode.LINEAR;
    public static final Mode NEAREST_NEIGHBOR = Mode.NEAREST_NEIGHBOR;
    public static final Mode BEST = Mode.LINEAR;

    public AbstractAffine3D(Image<T> img, float[] matrix, Mode mode, Number outside) throws Exception {
        this(img, matrix, mode, new OutOfBoundsStrategyValueFactory(AbstractAffine3D.withValue(img, (NumericType)img.createType(), outside)));
    }

    public AbstractAffine3D(Image<T> img, float[] matrix, Mode mode, OutOfBoundsStrategyFactory<T> oobf) throws Exception {
        super(AbstractAffine3D.process(img, matrix, mode, oobf).getContainer(), img.createType());
    }

    public AbstractAffine3D(Image<T> img, float scaleX, float shearX, float shearY, float scaleY, float translateX, float translateY, Mode mode, Number outside) throws Exception {
        this(img, new float[]{scaleX, shearX, 0.0f, translateX, shearY, scaleY, 0.0f, translateY, 0.0f, 0.0f, 1.0f, 0.0f}, mode, new OutOfBoundsStrategyValueFactory(AbstractAffine3D.withValue(img, (NumericType)img.createType(), outside)));
    }

    public AbstractAffine3D(Image<T> img, float scaleX, float shearX, float shearY, float scaleY, float translateX, float translateY, Mode mode, OutOfBoundsStrategyFactory<T> oobf) throws Exception {
        this(img, new float[]{scaleX, shearX, 0.0f, translateX, shearY, scaleY, 0.0f, translateY, 0.0f, 0.0f, 1.0f, 0.0f}, mode, oobf);
    }

    private static final NumericType<?> withValue(Image<? extends NumericType<?>> img, NumericType<?> type, Number val) {
        NumericType<?> t = img.createType();
        if (RGBALegacyType.class.isAssignableFrom(t.getClass())) {
            int i = val.intValue();
            t.set(new RGBALegacyType(i));
        } else {
            ((RealType)t).setReal(val.doubleValue());
        }
        return t;
    }

    private static final <N extends NumericType<N>> Image<N> process(Image<N> img, float[] matrix, Mode mode, OutOfBoundsStrategyFactory<N> oobf) throws Exception {
        if (matrix.length < 12) {
            throw new IllegalArgumentException("Affine transform in 2D requires a matrix array of 12 elements.");
        }
        N type = img.createType();
        if (RGBALegacyType.class.isAssignableFrom(type.getClass())) {
            return AbstractAffine3D.processRGBA(img, matrix, mode, oobf);
        }
        if (type instanceof RealType) {
            return AbstractAffine3D.processReal(img, matrix, mode, oobf);
        }
        throw new Exception("Affine transform: cannot handle type " + type.getClass());
    }

    private static final Image<RGBALegacyType> processRGBA(Image<RGBALegacyType> img, float[] m, Mode mode, OutOfBoundsStrategyFactory<RGBALegacyType> oobf) throws Exception {
        OutOfBoundsStrategyValueFactory<FloatType> oalpha;
        OutOfBoundsStrategyValueFactory<FloatType> oblue;
        OutOfBoundsStrategyValueFactory<FloatType> ogreen;
        OutOfBoundsStrategyValueFactory<FloatType> ored;
        if (OutOfBoundsStrategyValueFactory.class.isAssignableFrom(oobf.getClass())) {
            int val = ((RGBALegacyType)((OutOfBoundsStrategyValueFactory)oobf).getValue()).get();
            ored = new OutOfBoundsStrategyValueFactory<FloatType>(new FloatType(val >> 16 & 0xFF));
            ogreen = new OutOfBoundsStrategyValueFactory<FloatType>(new FloatType(val >> 8 & 0xFF));
            oblue = new OutOfBoundsStrategyValueFactory<FloatType>(new FloatType(val & 0xFF));
            oalpha = new OutOfBoundsStrategyValueFactory<FloatType>(new FloatType(val >> 24 & 0xFF));
        } else {
            try {
                ored = (OutOfBoundsStrategyValueFactory<FloatType>)oobf.getClass().newInstance();
            }
            catch (Exception e) {
                System.out.println("Affine3D for RGBA: oops -- using a black OutOfBoundsStrategyValueFactory");
                ored = new OutOfBoundsStrategyValueFactory<FloatType>(new FloatType());
            }
            ogreen = ored;
            oblue = ored;
            oalpha = ored;
        }
        return new RGBA(AbstractAffine3D.processReal(Compute.inFloats(new Red(img)), m, mode, ored), AbstractAffine3D.processReal(Compute.inFloats(new Green(img)), m, mode, ogreen), AbstractAffine3D.processReal(Compute.inFloats(new Blue(img)), m, mode, oblue), AbstractAffine3D.processReal(Compute.inFloats(new Alpha(img)), m, mode, oalpha)).asImage();
    }

    private static final <R extends RealType<R>> Image<R> processReal(Image<R> img, float[] m, Mode mode, OutOfBoundsStrategyFactory<R> oobf) throws Exception {
        ImageTransform<R> transform;
        InterpolatorFactory inter;
        switch (mode) {
            case LINEAR: {
                inter = new LinearInterpolatorFactory<R>(oobf);
                break;
            }
            case NEAREST_NEIGHBOR: {
                inter = new NearestNeighborInterpolatorFactory<R>(oobf);
                break;
            }
            default: {
                throw new IllegalArgumentException("Scale: don't know how to scale with mode " + (Object)((Object)mode));
            }
        }
        if (2 == img.getNumDimensions()) {
            AffineModel2D aff = new AffineModel2D();
            aff.set((double)m[0], (double)m[4], (double)m[1], (double)m[5], (double)m[3], (double)m[7]);
            transform = new ImageTransform<R>(img, aff, inter);
        } else if (3 == img.getNumDimensions()) {
            if (m.length < 12) {
                throw new IllegalArgumentException("Affine transform in 3D requires a matrix array of 12 elements.");
            }
            AffineModel3D aff = new AffineModel3D();
            aff.set((double)m[0], (double)m[1], (double)m[2], (double)m[3], (double)m[4], (double)m[5], (double)m[6], (double)m[7], (double)m[8], (double)m[9], (double)m[10], (double)m[11]);
            transform = new ImageTransform<R>(img, aff, inter);
            if ((double)Math.abs(m[10] - 1.0f) < 1.0E-6 && 0.0f == m[8] && 0.0f == m[9]) {
                int[] d = transform.getNewImageSize();
                d[2] = img.getDimension(2);
                transform.setNewImageSize(d);
            }
        } else {
            throw new Exception("Affine transform: only 2D and 3D images are supported.");
        }
        if (!transform.checkInput() || !transform.process()) {
            throw new Exception("Could not affine transform the image: " + transform.getErrorMessage());
        }
        return transform.getResult();
    }

    public static enum Mode {
        LINEAR,
        NEAREST_NEIGHBOR;

    }
}

