/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.color;

import java.util.Collection;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.color.fn.ColorFunction;
import script.imglib.math.fn.IFunction;

public final class RGBA
extends ColorFunction {
    private final IFunction red;
    private final IFunction green;
    private final IFunction blue;
    private final IFunction alpha;

    public RGBA(IFunction red, IFunction green, IFunction blue, IFunction alpha) {
        this.red = null == red ? empty : red;
        this.green = null == green ? empty : green;
        this.blue = null == blue ? empty : blue;
        this.alpha = null == alpha ? empty : alpha;
    }

    public RGBA(Image<? extends RealType<?>> img) {
        this(new ColorFunction.Channel(img, 3), new ColorFunction.Channel(img, 2), new ColorFunction.Channel(img, 1), new ColorFunction.Channel(img, 4));
    }

    public RGBA(Object red, Object green, Object blue, Object alpha) throws Exception {
        this(RGBA.wrap(red), RGBA.wrap(green), RGBA.wrap(blue), RGBA.wrap(alpha));
    }

    public RGBA(Object red, Object green, Object blue) throws Exception {
        this(RGBA.wrap(red), RGBA.wrap(green), RGBA.wrap(blue), empty);
    }

    public RGBA(Object red, Object green) throws Exception {
        this(RGBA.wrap(red), RGBA.wrap(green), empty, empty);
    }

    public RGBA(Object red) throws Exception {
        this(RGBA.wrap(red), empty, empty, empty);
    }

    public RGBA(IFunction fn, int channel) throws IllegalArgumentException {
        this(3 == channel ? fn : empty, 2 == channel ? fn : empty, 1 == channel ? fn : empty, 4 == channel ? fn : empty);
        if (channel < 1 || channel > 4) {
            throw new IllegalArgumentException("RGB: channel must be >= 1 and <= 4");
        }
    }

    public RGBA(Object ob, int channel) throws Exception, IllegalArgumentException {
        this(RGBA.wrap(ob), channel);
        if (channel < 1 || channel > 4) {
            throw new IllegalArgumentException("RGB: channel must be >= 1 and <= 4");
        }
    }

    @Override
    public final IFunction duplicate() throws Exception {
        return new RGBA(this.red.duplicate(), this.green.duplicate(), this.blue.duplicate(), this.alpha.duplicate());
    }

    @Override
    public final double eval() {
        return ((int)this.alpha.eval() & 0xFF) << 24 | ((int)this.red.eval() & 0xFF) << 16 | ((int)this.green.eval() & 0xFF) << 8 | (int)this.blue.eval() & 0xFF;
    }

    @Override
    public final void findCursors(Collection<Cursor<?>> cursors) {
        this.alpha.findCursors(cursors);
        this.red.findCursors(cursors);
        this.green.findCursors(cursors);
        this.blue.findCursors(cursors);
    }
}

