/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.color.fn;

import java.util.Collection;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RGBALegacyType;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;
import script.imglib.math.fn.ImageComputation;
import script.imglib.math.fn.NumberFunction;
import script.imglib.math.fn.Util;

public abstract class ColorFunction
implements IFunction,
ImageComputation<RGBALegacyType> {
    protected static final NumberFunction empty = new NumberFunction(0.0);

    protected static IFunction wrap(Object ob) throws Exception {
        if (null == ob) {
            return empty;
        }
        return Util.wrap(ob);
    }

    @Override
    public Image<RGBALegacyType> asImage() throws Exception {
        return this.asImage(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public Image<RGBALegacyType> asImage(int numThreads) throws Exception {
        return Compute.apply((IFunction)this, new RGBALegacyType(), numThreads);
    }

    public static final class Channel
    implements IFunction {
        final Cursor<? extends RealType<?>> c;
        final int shift;

        public Channel(Image<? extends RealType<?>> img, int channel) {
            this.c = img.createCursor();
            this.shift = (channel - 1) * 8;
        }

        @Override
        public final IFunction duplicate() throws Exception {
            return new Channel(this.c.getImage(), this.shift / 8 + 1);
        }

        @Override
        public final double eval() {
            this.c.fwd();
            return (int)this.c.getType().getRealDouble() >> this.shift & 0xFF;
        }

        @Override
        public final void findCursors(Collection<Cursor<?>> cursors) {
            cursors.add(this.c);
        }
    }
}

