/*
 * Decompiled with CFR 0.152.
 */
package bunwarpj;

import ij.IJ;

public class ProgressBar {
    private static final long TIME_QUANTUM = 50L;
    private static volatile long lastTime = System.currentTimeMillis();
    private static volatile int completed = 0;
    private static volatile int workload = 0;

    public static synchronized void addWorkload(int batch) {
        workload += batch;
    }

    public static synchronized void resetProgressBar() {
        long timeStamp = System.currentTimeMillis();
        if (timeStamp - lastTime < 50L) {
            try {
                Thread.sleep(50L - timeStamp + lastTime);
            }
            catch (InterruptedException e) {
                IJ.error((String)("Unexpected interruption exception" + e));
            }
        }
        lastTime = timeStamp;
        completed = 0;
        workload = 0;
        IJ.showProgress((double)1.0);
    }

    public static synchronized void skipProgressBar(int stride) {
        completed += stride - 1;
        ProgressBar.stepProgressBar();
    }

    public static synchronized void stepProgressBar() {
        long timeStamp = System.currentTimeMillis();
        if (50L <= timeStamp - lastTime | ++completed == workload) {
            lastTime = timeStamp;
            IJ.showProgress((double)((double)completed / (double)workload));
        }
    }

    public static synchronized void workloadDone(int batch) {
        workload -= batch;
        completed -= batch;
    }
}

