/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.convert.NativeData;
import java.math.BigInteger;

public final class UnsignedIntUtils {
    private static final short MAX_UINT_8_P1 = 256;
    private static final short MAX_UINT_8 = 255;
    private static final int MAX_UINT_16_P1 = 65536;
    private static final int MAX_UINT_16 = 65535;
    private static final long MAX_UINT_32_P1 = 0x100000000L;
    private static final long MAX_UINT_32 = 0xFFFFFFFFL;
    private static final BigInteger MAX_UINT_64_P1 = new BigInteger("2").pow(64);
    private static final BigInteger MAX_UINT_64 = MAX_UINT_64_P1.subtract(BigInteger.ONE);

    public static byte toInt8(int value) throws IllegalArgumentException {
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Value " + Integer.toString(value) + " cannot be converted to uint8.");
        }
        return (byte)value;
    }

    public static short toInt16(int value) throws IllegalArgumentException {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("Value " + Integer.toString(value) + " cannot be converted to uint16.");
        }
        return (short)value;
    }

    public static int toInt32(long value) throws IllegalArgumentException {
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value " + Long.toString(value) + " cannot be converted to uint32.");
        }
        return (int)value;
    }

    public static long toInt64(BigInteger value) throws IllegalArgumentException {
        if (value.compareTo(BigInteger.ZERO) < 0 || value.compareTo(MAX_UINT_64) > 0) {
            throw new IllegalArgumentException("Value " + value.toString() + " cannot be converted to uint64.");
        }
        return value.longValue();
    }

    public static short toUint8(byte value) {
        return (short)(value < 0 ? 256 + value : value);
    }

    public static int toUint16(short value) {
        return value < 0 ? 65536 + value : value;
    }

    public static long toUint32(int value) {
        return value < 0 ? 0x100000000L + (long)value : (long)value;
    }

    public static BigInteger toUint64(long value) {
        return new BigInteger(1, NativeData.longToByte((long[])new long[]{value}, (NativeData.ByteOrder)NativeData.ByteOrder.BIG_ENDIAN));
    }
}

