/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.algorithm.blocks.ClampType;
import net.imglib2.algorithm.blocks.ConcatenatedBlockSupplier;
import net.imglib2.algorithm.blocks.ConcatenatedUnaryBlockOperator;
import net.imglib2.algorithm.blocks.convert.Convert;
import net.imglib2.type.NativeType;

public interface UnaryBlockOperator<S extends NativeType<S>, T extends NativeType<T>> {
    public void compute(BlockSupplier<S> var1, Interval var2, Object var3);

    public S getSourceType();

    public T getTargetType();

    public int numSourceDimensions();

    public int numTargetDimensions();

    public UnaryBlockOperator<S, T> independentCopy();

    default public BlockSupplier<T> applyTo(BlockSupplier<S> blocks) {
        return new ConcatenatedBlockSupplier<S, T>(blocks, this.independentCopy());
    }

    default public <U extends NativeType<U>> UnaryBlockOperator<S, U> andThen(UnaryBlockOperator<T, U> op) {
        return new ConcatenatedUnaryBlockOperator(this, op.independentCopy());
    }

    default public <U extends NativeType<U>> UnaryBlockOperator<U, T> adaptSourceType(U newSourceType, ClampType clamp) {
        return Convert.createOperator(newSourceType, this.getSourceType(), clamp).andThen(this);
    }

    default public <U extends NativeType<U>> UnaryBlockOperator<S, U> adaptTargetType(U newTargetType, ClampType clamp) {
        return this.andThen(Convert.createOperator(this.getTargetType(), newTargetType, clamp));
    }
}

