/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.transform;

import net.imglib2.algorithm.blocks.transform.Transform;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Cast;

@FunctionalInterface
interface TransformLine3D<P> {
    public void apply(P var1, P var2, int var3, int var4, float var5, float var6, float var7, int var8, int var9, float var10, float var11, float var12);

    public static <P> TransformLine3D<P> of(Transform.Interpolation interpolation, PrimitiveType primitiveType) {
        if (interpolation == Transform.Interpolation.NLINEAR) {
            switch (primitiveType) {
                case FLOAT: {
                    return (TransformLine3D)Cast.unchecked(NLinear_float.INSTANCE);
                }
                case DOUBLE: {
                    return (TransformLine3D)Cast.unchecked(NLinear_double.INSTANCE);
                }
            }
            throw new IllegalArgumentException();
        }
        switch (primitiveType) {
            case BYTE: {
                return (TransformLine3D)Cast.unchecked(NearestNeighbor_byte.INSTANCE);
            }
            case SHORT: {
                return (TransformLine3D)Cast.unchecked(NearestNeighbor_short.INSTANCE);
            }
            case INT: {
                return (TransformLine3D)Cast.unchecked(NearestNeighbor_int.INSTANCE);
            }
            case LONG: {
                return (TransformLine3D)Cast.unchecked(NearestNeighbor_long.INSTANCE);
            }
            case FLOAT: {
                return (TransformLine3D)Cast.unchecked(NearestNeighbor_float.INSTANCE);
            }
            case DOUBLE: {
                return (TransformLine3D)Cast.unchecked(NearestNeighbor_double.INSTANCE);
            }
        }
        throw new IllegalArgumentException();
    }

    public static class NearestNeighbor_long
    implements TransformLine3D<long[]> {
        static final NearestNeighbor_long INSTANCE = new NearestNeighbor_long();

        private NearestNeighbor_long() {
        }

        @Override
        public void apply(long[] src, long[] dest, int offset, int length, float d0, float d1, float d2, int ss0, int ss1, float sf0, float sf1, float sf2) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            sf2 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                int s2 = (int)sf2;
                dest[offset++] = src[s2 * ss1 + s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
                sf2 += d2;
            }
        }
    }

    public static class NearestNeighbor_int
    implements TransformLine3D<int[]> {
        static final NearestNeighbor_int INSTANCE = new NearestNeighbor_int();

        private NearestNeighbor_int() {
        }

        @Override
        public void apply(int[] src, int[] dest, int offset, int length, float d0, float d1, float d2, int ss0, int ss1, float sf0, float sf1, float sf2) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            sf2 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                int s2 = (int)sf2;
                dest[offset++] = src[s2 * ss1 + s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
                sf2 += d2;
            }
        }
    }

    public static class NearestNeighbor_short
    implements TransformLine3D<short[]> {
        static final NearestNeighbor_short INSTANCE = new NearestNeighbor_short();

        private NearestNeighbor_short() {
        }

        @Override
        public void apply(short[] src, short[] dest, int offset, int length, float d0, float d1, float d2, int ss0, int ss1, float sf0, float sf1, float sf2) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            sf2 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                int s2 = (int)sf2;
                dest[offset++] = src[s2 * ss1 + s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
                sf2 += d2;
            }
        }
    }

    public static class NearestNeighbor_byte
    implements TransformLine3D<byte[]> {
        static final NearestNeighbor_byte INSTANCE = new NearestNeighbor_byte();

        private NearestNeighbor_byte() {
        }

        @Override
        public void apply(byte[] src, byte[] dest, int offset, int length, float d0, float d1, float d2, int ss0, int ss1, float sf0, float sf1, float sf2) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            sf2 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                int s2 = (int)sf2;
                dest[offset++] = src[s2 * ss1 + s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
                sf2 += d2;
            }
        }
    }

    public static class NearestNeighbor_double
    implements TransformLine3D<double[]> {
        static final NearestNeighbor_double INSTANCE = new NearestNeighbor_double();

        private NearestNeighbor_double() {
        }

        @Override
        public void apply(double[] src, double[] dest, int offset, int length, float d0, float d1, float d2, int ss0, int ss1, float sf0, float sf1, float sf2) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            sf2 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                int s2 = (int)sf2;
                dest[offset++] = src[s2 * ss1 + s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
                sf2 += d2;
            }
        }
    }

    public static class NearestNeighbor_float
    implements TransformLine3D<float[]> {
        static final NearestNeighbor_float INSTANCE = new NearestNeighbor_float();

        private NearestNeighbor_float() {
        }

        @Override
        public void apply(float[] src, float[] dest, int offset, int length, float d0, float d1, float d2, int ss0, int ss1, float sf0, float sf1, float sf2) {
            sf0 += 0.5f;
            sf1 += 0.5f;
            sf2 += 0.5f;
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                int s2 = (int)sf2;
                dest[offset++] = src[s2 * ss1 + s1 * ss0 + s0];
                sf0 += d0;
                sf1 += d1;
                sf2 += d2;
            }
        }
    }

    public static class NLinear_double
    implements TransformLine3D<double[]> {
        static final NLinear_double INSTANCE = new NLinear_double();

        private NLinear_double() {
        }

        @Override
        public void apply(double[] src, double[] dest, int offset, int length, float d0, float d1, float d2, int ss0, int ss1, float sf0, float sf1, float sf2) {
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                int s2 = (int)sf2;
                float r0 = sf0 - (float)s0;
                float r1 = sf1 - (float)s1;
                float r2 = sf2 - (float)s2;
                int o = s2 * ss1 + s1 * ss0 + s0;
                double a000 = src[o];
                double a001 = src[o + 1];
                double a010 = src[o + ss0];
                double a011 = src[o + ss0 + 1];
                double a100 = src[o + ss1];
                double a101 = src[o + ss1 + 1];
                double a110 = src[o + ss1 + ss0];
                double a111 = src[o + ss1 + ss0 + 1];
                dest[offset++] = a000 + (double)r0 * (-a000 + a001) + (double)r1 * (-a000 + a010 + (double)r0 * (a000 - a001 - a010 + a011)) + (double)r2 * (-a000 + a100 + (double)r0 * (a000 - a001 - a100 + a101) + (double)r1 * (a000 - a010 - a100 + a110 + (double)r0 * (-a000 + a001 + a010 - a011 + a100 - a101 - a110 + a111)));
                sf0 += d0;
                sf1 += d1;
                sf2 += d2;
            }
        }
    }

    public static class NLinear_float
    implements TransformLine3D<float[]> {
        static final NLinear_float INSTANCE = new NLinear_float();

        private NLinear_float() {
        }

        @Override
        public void apply(float[] src, float[] dest, int offset, int length, float d0, float d1, float d2, int ss0, int ss1, float sf0, float sf1, float sf2) {
            for (int x = 0; x < length; ++x) {
                int s0 = (int)sf0;
                int s1 = (int)sf1;
                int s2 = (int)sf2;
                float r0 = sf0 - (float)s0;
                float r1 = sf1 - (float)s1;
                float r2 = sf2 - (float)s2;
                int o = s2 * ss1 + s1 * ss0 + s0;
                float a000 = src[o];
                float a001 = src[o + 1];
                float a010 = src[o + ss0];
                float a011 = src[o + ss0 + 1];
                float a100 = src[o + ss1];
                float a101 = src[o + ss1 + 1];
                float a110 = src[o + ss1 + ss0];
                float a111 = src[o + ss1 + ss0 + 1];
                dest[offset++] = a000 + r0 * (-a000 + a001) + r1 * (-a000 + a010 + r0 * (a000 - a001 - a010 + a011)) + r2 * (-a000 + a100 + r0 * (a000 - a001 - a100 + a101) + r1 * (a000 - a010 - a100 + a110 + r0 * (-a000 + a001 + a010 - a011 + a100 - a101 - a110 + a111)));
                sf0 += d0;
                sf1 += d1;
                sf2 += d2;
            }
        }
    }
}

