/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.bspline;

import java.util.Arrays;
import java.util.function.Consumer;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class BSplineDecomposition<T extends RealType<T>, S extends RealType<S>>
implements Consumer<RandomAccessibleInterval<S>> {
    protected final int order;
    protected final int numberOfPoles;
    protected final double[] poles;
    protected final double[] Ci;
    protected final RandomAccessible<T> img;
    protected double tolerance = 1.0E-6;
    protected int paddingWidth = 4;
    protected int initHorizon = 6;
    protected double[] padding;
    protected RandomAccessibleInterval<S> tmpCoefStorage;
    protected Interval originalInterval;
    protected boolean isPadded = true;

    public BSplineDecomposition(int order, RandomAccessible<T> img) {
        assert (order <= 5);
        this.order = order;
        this.img = img;
        this.poles = BSplineDecomposition.poles(order);
        this.numberOfPoles = this.poles.length;
        this.Ci = BSplineDecomposition.polesCi(this.poles);
        this.padding = new double[this.paddingWidth];
    }

    public BSplineDecomposition(RandomAccessible<T> img) {
        this(3, img);
    }

    public void setPadded(boolean isPadded) {
        this.isPadded = isPadded;
    }

    public RandomAccessible<T> getImage() {
        return this.img;
    }

    public static double[] polesCi(double[] poles) {
        double[] Ci = new double[poles.length];
        for (int i = 0; i < poles.length; ++i) {
            Ci[i] = poles[i] / (poles[i] * poles[i] - 1.0);
        }
        return Ci;
    }

    public static double gainFromPoles(double[] poles) {
        double c0 = 1.0;
        for (int k = 0; k < poles.length; ++k) {
            c0 = c0 * (1.0 - poles[k]) * (1.0 - 1.0 / poles[k]);
        }
        return c0;
    }

    @Override
    public void accept(RandomAccessibleInterval<S> coefficients) {
        if (this.isPadded) {
            this.originalInterval = coefficients;
            FinalInterval itvl = Intervals.expand(coefficients, (long)this.paddingWidth);
            Img paddedImgZero = Util.getSuitableImgFactory(itvl, Util.getTypeFromInterval(coefficients)).create(itvl);
            IntervalView paddedImg = Views.translate(paddedImgZero, Intervals.minAsLongArray(itvl));
            this.acceptUnpadded(paddedImg);
            IntervalView subImg = Views.interval(paddedImg, coefficients);
            LoopBuilder.setImages(subImg, coefficients).forEachPixel((x, y) -> y.set(x));
        } else {
            this.acceptUnpadded(coefficients);
        }
    }

    public void acceptUnpadded(RandomAccessibleInterval<S> coefficients) {
        int nd = this.img.numDimensions();
        RandomAccess imgAccess = this.img.randomAccess();
        RandomAccess coefAccess = coefficients.randomAccess();
        RandomAccess coefExtAccess = Views.extendMirrorSingle(coefficients).randomAccess();
        Point startPoint = new Point(Intervals.minAsLongArray(coefficients));
        imgAccess.setPosition(startPoint);
        coefAccess.setPosition(startPoint);
        coefExtAccess.setPosition(startPoint);
        RealType var = (RealType)((RealType)coefAccess.get()).createVariable();
        for (int d = 0; d < nd; ++d) {
            Interval itvl;
            RandomAccess dataAccess = d == 0 ? imgAccess : coefExtAccess;
            IntervalIterator it = BSplineDecomposition.getIterator(coefficients, d);
            if (d == nd - 1 && this.originalInterval != null) {
                itvl = this.originalInterval;
                it = BSplineDecomposition.getIterator(coefficients, this.originalInterval, d);
            } else {
                itvl = coefficients;
                it = BSplineDecomposition.getIterator(coefficients, d);
            }
            while (it.hasNext()) {
                it.fwd();
                for (int pole_idx = 0; pole_idx < this.numberOfPoles; ++pole_idx) {
                    RandomAccess destAccess;
                    RandomAccess srcAccess;
                    if (pole_idx == 0) {
                        dataAccess.setPosition(it);
                        coefAccess.setPosition(it);
                        srcAccess = dataAccess;
                        destAccess = coefAccess;
                    } else {
                        srcAccess = coefExtAccess;
                        srcAccess.setPosition(it);
                        destAccess = coefAccess;
                        destAccess.setPosition(it);
                    }
                    this.recursion1d(srcAccess, destAccess, this.poles[pole_idx], this.Ci[pole_idx], var, itvl.dimension(d), d);
                }
            }
        }
    }

    public static IntervalIterator getIterator(Interval paddedInterval, Interval originalInterval, int dim) {
        int nd = paddedInterval.numDimensions();
        long[] min = new long[nd];
        long[] max = new long[nd];
        for (int d = 0; d < nd; ++d) {
            if (d == dim) {
                min[d] = originalInterval.min(d);
                max[d] = originalInterval.min(d);
                continue;
            }
            min[d] = paddedInterval.min(d);
            max[d] = paddedInterval.max(d);
        }
        return new IntervalIterator(min, max);
    }

    public static IntervalIterator getIterator(Interval interval, int dim) {
        int nd = interval.numDimensions();
        long[] min = new long[nd];
        long[] max = new long[nd];
        for (int d = 0; d < nd; ++d) {
            if (d == dim) {
                min[d] = interval.min(d);
                max[d] = interval.min(d);
                continue;
            }
            min[d] = interval.min(d);
            max[d] = interval.max(d);
        }
        return new IntervalIterator(min, max);
    }

    public static <S extends RealType<S>, T extends RealType<T>> void recursion1dUnpadded(RandomAccess<T> srcAccess, RandomAccess<S> destAccess, S previous, long N, int dimension, double tolerance, int numberOfPoles, double[] poles, double[] Ci) {
        for (int pole_idx = 0; pole_idx < numberOfPoles; ++pole_idx) {
            double z = poles[pole_idx];
            System.out.println("pole: " + z);
            double c0 = BSplineDecomposition.initializeCausalCoefficients(z, tolerance, dimension, srcAccess);
            ((RealType)destAccess.get()).setReal(c0);
            previous.set((Type)((Type)destAccess.get()));
            int i = 1;
            while ((long)i < N) {
                srcAccess.fwd(dimension);
                destAccess.fwd(dimension);
                RealType coef = (RealType)destAccess.get();
                coef.setReal(((RealType)srcAccess.get()).getRealDouble());
                previous.mul((double)z);
                coef.add(previous);
                previous.set((RealType)coef);
                ++i;
            }
            BSplineDecomposition.initializeAntiCausalCoefficients(z, Ci[pole_idx], previous, destAccess);
            for (long i2 = N - 2L; i2 >= 0L; --i2) {
                RealType coef = (RealType)destAccess.get();
                coef.sub(previous);
                coef.mul(-z);
                previous.set((RealType)coef);
                srcAccess.bck(dimension);
                destAccess.bck(dimension);
            }
        }
    }

    public <S extends RealType<S>, T extends RealType<T>> void recursion1d(RandomAccess<T> srcAccess, RandomAccess<S> destAccess, double z, double Ci, S previous, long N, int dimension) {
        double c0 = BSplineDecomposition.initializeCausalCoefficients(z, this.tolerance, dimension, srcAccess);
        ((RealType)destAccess.get()).setReal(c0);
        previous.set((Type)((Type)destAccess.get()));
        int i = 1;
        while ((long)i < N) {
            srcAccess.fwd(dimension);
            destAccess.fwd(dimension);
            RealType coef = (RealType)destAccess.get();
            coef.setReal(((RealType)srcAccess.get()).getRealDouble());
            previous.mul((double)z);
            coef.add(previous);
            previous.set((RealType)coef);
            ++i;
        }
        previous.setReal(this.padOperation(srcAccess, dimension, previous.getRealDouble(), z, Ci));
        for (long i2 = N - 1L; i2 >= 0L; --i2) {
            RealType coef = (RealType)destAccess.get();
            coef.sub(previous);
            coef.mul(-z);
            previous.set((RealType)coef);
            srcAccess.bck(dimension);
            destAccess.bck(dimension);
        }
    }

    private <R extends RealType<R>> double padOperation(RandomAccess<R> access, int dimension, double last, double z, double Ci) {
        int i;
        access.fwd(dimension);
        this.padding[0] = ((RealType)access.get()).getRealDouble() + z * last;
        for (i = 1; i < this.paddingWidth; ++i) {
            access.fwd(dimension);
            this.padding[i] = ((RealType)access.get()).getRealDouble() + z * this.padding[i - 1];
        }
        int n = this.paddingWidth - 1;
        this.padding[n] = this.padding[n] + z * this.padding[this.paddingWidth - 2];
        int n2 = this.paddingWidth - 1;
        this.padding[n2] = this.padding[n2] * Ci;
        for (i = this.paddingWidth - 2; i >= 0; --i) {
            this.padding[i] = z * (this.padding[i + 1] - this.padding[i]);
        }
        return this.padding[0];
    }

    protected static <T extends RealType<T>> void initializeAntiCausalCoefficients(double z, double c, T previous, RandomAccess<T> coefs) {
        RealType last = (RealType)coefs.get();
        coefs.bck(0);
        previous.set((Type)((Type)coefs.get()));
        previous.mul(z);
        last.add(previous);
        last.mul(c);
        previous.set((RealType)last);
    }

    protected static <T extends RealType<T>> double initializeCausalCoefficients(double z, double tolerance, int dimension, RandomAccess<T> dataAccess) {
        int horizon = 6;
        double zn = z;
        double sum = ((RealType)dataAccess.get()).getRealDouble();
        for (int i = 0; i < horizon; ++i) {
            dataAccess.bck(dimension);
            sum += zn * ((RealType)dataAccess.get()).getRealDouble();
            zn *= z;
        }
        dataAccess.move(horizon, dimension);
        return sum;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("BSplineDecomposition\n");
        s.append("  Spline order: " + this.order + "\n");
        s.append("  Spline poles: " + Arrays.toString(this.poles) + "\n");
        s.append("  Num poles   : " + this.numberOfPoles + "\n");
        return s.toString();
    }

    public static double[] poles(int splineOrder) {
        switch (splineOrder) {
            case 0: {
                return new double[0];
            }
            case 1: {
                return new double[0];
            }
            case 2: {
                return new double[]{Math.sqrt(8.0) - 3.0};
            }
            case 3: {
                return new double[]{Math.sqrt(3.0) - 2.0};
            }
            case 4: {
                return new double[]{Math.sqrt(664.0 - Math.sqrt(438976.0)) + Math.sqrt(304.0) - 19.0, Math.sqrt(664.0 + Math.sqrt(438976.0)) - Math.sqrt(304.0) - 19.0};
            }
            case 5: {
                return new double[]{Math.sqrt(67.5 - Math.sqrt(4436.25)) + Math.sqrt(26.25) - 6.5, Math.sqrt(67.5 + Math.sqrt(4436.25)) - Math.sqrt(26.25) - 6.5};
            }
        }
        return null;
    }
}

