/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution.fast_gauss;

import java.util.Arrays;
import java.util.List;
import net.imglib2.RandomAccess;
import net.imglib2.algorithm.convolution.LineConvolverFactory;
import net.imglib2.algorithm.convolution.fast_gauss.FastGaussCalculator;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

public class FastGaussConvolverRealType
implements LineConvolverFactory<RealType<?>> {
    private final FastGaussCalculator.Parameters fc;
    private static final ClassCopyProvider<Runnable> provider = new ClassCopyProvider<Runnable>(MyConvolver.class, Runnable.class, new Class[0]);

    public FastGaussConvolverRealType(double sigma) {
        this.fc = FastGaussCalculator.Parameters.exact(sigma);
    }

    @Override
    public long getBorderBefore() {
        return this.fc.N + 1;
    }

    @Override
    public long getBorderAfter() {
        return this.fc.N - 1;
    }

    @Override
    public Runnable getConvolver(RandomAccess<? extends RealType<?>> in, RandomAccess<? extends RealType<?>> out, int d, long lineLength) {
        List<Class> key = Arrays.asList(in.getClass(), out.getClass(), ((RealType)in.get()).getClass(), ((RealType)out.get()).getClass());
        return provider.newInstanceForKey(key, d, this.fc, in, out, lineLength);
    }

    @Override
    public RealType<?> preferredSourceType(RealType<?> targetType) {
        return targetType instanceof DoubleType ? targetType : new FloatType();
    }

    public static class MyConvolver
    implements Runnable {
        private final int d;
        private final RandomAccess<? extends RealType<?>> in;
        private final RandomAccess<? extends RealType<?>> out;
        private final long lineLength;
        private final FastGaussCalculator fg;
        private final int offset;
        private final double[] tmpE;

        public MyConvolver(int d, FastGaussCalculator.Parameters fc, RandomAccess<? extends RealType<?>> in, RandomAccess<? extends RealType<?>> out, long lineLength) {
            if (lineLength > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException();
            }
            this.d = d;
            this.in = in;
            this.out = out;
            this.lineLength = lineLength;
            this.offset = 2 * fc.N;
            this.tmpE = new double[(int)lineLength + this.offset];
            this.fg = new FastGaussCalculator(fc);
        }

        @Override
        public void run() {
            int i;
            int i2 = 0;
            while ((long)i2 < this.lineLength + (long)this.offset) {
                this.tmpE[i2] = ((RealType)this.in.get()).getRealDouble();
                this.in.fwd(this.d);
                ++i2;
            }
            double boundaryValue = this.tmpE[0];
            this.fg.initialize(boundaryValue);
            for (i = -this.offset; i < 0; ++i) {
                this.fg.update(boundaryValue + this.tmpE[i + this.offset]);
            }
            i = 0;
            while ((long)i < this.lineLength) {
                this.fg.update(this.tmpE[i] + this.tmpE[i + this.offset]);
                ((RealType)this.out.get()).setReal(this.fg.getValue());
                this.out.fwd(this.d);
                ++i;
            }
        }
    }
}

