/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.convolution.kernel;

import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Kernel1D {
    private final double[] fullKernel;
    private final int centralIndex;

    public static Kernel1D symmetric(double ... halfKernel) {
        Objects.requireNonNull(halfKernel);
        return new Kernel1D(Kernel1D.halfToFullKernel(halfKernel), halfKernel.length - 1);
    }

    public static Kernel1D[] symmetric(double[][] halfKernels) {
        return (Kernel1D[])Stream.of(halfKernels).map(Kernel1D::symmetric).toArray(Kernel1D[]::new);
    }

    public static Kernel1D asymmetric(double[] fullKernel, int originIndex) {
        Objects.requireNonNull(fullKernel);
        return new Kernel1D(fullKernel, originIndex);
    }

    public static Kernel1D centralAsymmetric(double ... kernel) {
        return Kernel1D.asymmetric(kernel, (kernel.length - 1) / 2);
    }

    public static Kernel1D[] asymmetric(double[][] fullKernels, int[] originIndices) {
        return (Kernel1D[])IntStream.range(0, fullKernels.length).mapToObj(d -> Kernel1D.asymmetric(fullKernels[d], originIndices[d])).toArray(Kernel1D[]::new);
    }

    public static Kernel1D[] centralAsymmetric(double[][] kernels) {
        return (Kernel1D[])Stream.of(kernels).map(Kernel1D::centralAsymmetric).toArray(Kernel1D[]::new);
    }

    private Kernel1D(double[] fullKernel, int centralIndex) {
        this.fullKernel = fullKernel;
        this.centralIndex = centralIndex;
    }

    public double[] fullKernel() {
        return this.fullKernel;
    }

    public long min() {
        return -this.centralIndex;
    }

    public long max() {
        return this.size() - 1 - this.centralIndex;
    }

    public int size() {
        return this.fullKernel().length;
    }

    public static double[] halfToFullKernel(double[] halfKernel) {
        int k = halfKernel.length;
        int k1 = k - 1;
        double[] kernel = new double[k1 + k];
        for (int i = 0; i < k; ++i) {
            kernel[k1 - i] = halfKernel[i];
            kernel[k1 + i] = halfKernel[i];
        }
        return kernel;
    }
}

