/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss3;

import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.convolution.Convolution;
import net.imglib2.algorithm.convolution.kernel.Kernel1D;
import net.imglib2.algorithm.convolution.kernel.SeparableKernelConvolution;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.parallel.Parallelization;
import net.imglib2.type.numeric.NumericType;

public final class Gauss3 {
    public static <S extends NumericType<S>, T extends NumericType<T>> void gauss(double sigma, RandomAccessible<S> source, RandomAccessibleInterval<T> target) throws IncompatibleTypeException {
        int n = source.numDimensions();
        double[] s = new double[n];
        for (int d = 0; d < n; ++d) {
            s[d] = sigma;
        }
        Gauss3.gauss(s, source, target);
    }

    public static <S extends NumericType<S>, T extends NumericType<T>> void gauss(double[] sigma, RandomAccessible<S> source, RandomAccessibleInterval<T> target) throws IncompatibleTypeException {
        double[][] halfkernels = Gauss3.halfkernels(sigma);
        Convolution<NumericType<?>> convolution = SeparableKernelConvolution.convolution(Kernel1D.symmetric(halfkernels));
        convolution.process(source, target);
    }

    @Deprecated
    public static <S extends NumericType<S>, T extends NumericType<T>> void gauss(double[] sigma, RandomAccessible<S> source, RandomAccessibleInterval<T> target, int numThreads) throws IncompatibleTypeException {
        Parallelization.runWithNumThreads(numThreads, () -> Gauss3.gauss(sigma, source, target));
    }

    @Deprecated
    public static <S extends NumericType<S>, T extends NumericType<T>> void gauss(double[] sigma, RandomAccessible<S> source, RandomAccessibleInterval<T> target, ExecutorService service) throws IncompatibleTypeException {
        Parallelization.runWithExecutor(service, () -> Gauss3.gauss(sigma, source, target));
    }

    public static double[][] halfkernels(double[] sigma) {
        double[][] halfkernels = new double[sigma.length][];
        Arrays.setAll(halfkernels, i -> Gauss3.halfkernel(sigma[i]));
        return halfkernels;
    }

    public static int[] halfkernelsizes(double[] sigma) {
        int[] size = new int[sigma.length];
        Arrays.setAll(size, i -> Gauss3.halfkernelsize(sigma[i]));
        return size;
    }

    public static int halfkernelsize(double sigma) {
        return Math.max(2, (int)(3.0 * sigma + 0.5) + 1);
    }

    public static double[] halfkernel(double sigma) {
        return Gauss3.halfkernel(sigma, Gauss3.halfkernelsize(sigma), true);
    }

    public static double[] halfkernel(double sigma, int size, boolean normalize) {
        double two_sq_sigma = 2.0 * Gauss3.square(sigma);
        double[] kernel = new double[size];
        kernel[0] = 1.0;
        for (int x = 1; x < size; ++x) {
            kernel[x] = Math.exp(-Gauss3.square(x) / two_sq_sigma);
        }
        Gauss3.smoothEdge(kernel);
        if (normalize) {
            Gauss3.normalizeHalfkernel(kernel);
        }
        return kernel;
    }

    private static void smoothEdge(double[] kernel) {
        int L = kernel.length;
        double slope = Double.MAX_VALUE;
        int r = L;
        while (r > L / 2) {
            double a;
            if ((a = kernel[--r] / Gauss3.square(L - r)) < slope) {
                slope = a;
                continue;
            }
            ++r;
            break;
        }
        for (int x = r + 1; x < L; ++x) {
            kernel[x] = slope * Gauss3.square(L - x);
        }
    }

    private static void normalizeHalfkernel(double[] kernel) {
        double sum = 0.5 * kernel[0];
        for (int x = 1; x < kernel.length; ++x) {
            sum += kernel[x];
        }
        Gauss3.multiply(kernel, 1.0 / (sum *= 2.0));
    }

    private static double square(double x) {
        return x * x;
    }

    private static void multiply(double[] values, double factor) {
        int x = 0;
        while (x < values.length) {
            int n = x++;
            values[n] = values[n] * factor;
        }
    }
}

