/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import java.util.Arrays;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.math.abstractions.IImgSourceIterable;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class ImgSourceIterableDirect<O extends RealType<O>>
implements OFunction<O>,
IImgSourceIterable<O> {
    private final RandomAccessibleInterval<O> rai;
    private final Cursor<O> it;
    private final RandomAccess<O> ra;

    public ImgSourceIterableDirect(RandomAccessibleInterval<O> rai) {
        this.rai = rai;
        this.it = Views.iterable(rai).cursor();
        this.ra = rai.randomAccess();
    }

    @Override
    public final O eval() {
        return (O)((RealType)this.it.next());
    }

    @Override
    public final O eval(Localizable loc) {
        this.ra.setPosition(loc);
        return (O)((RealType)this.ra.get());
    }

    public RandomAccessibleInterval<O> getRandomAccessibleInterval() {
        return this.rai;
    }

    @Override
    public Cursor<O> getCursor() {
        return this.it;
    }

    @Override
    public List<OFunction<O>> children() {
        return Arrays.asList(new OFunction[0]);
    }

    @Override
    public final double evalDouble() {
        return ((RealType)this.it.next()).getRealDouble();
    }

    @Override
    public final double evalDouble(Localizable loc) {
        this.ra.setPosition(loc);
        return ((RealType)this.ra.get()).getRealDouble();
    }
}

