/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology;

import java.util.Vector;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.morphology.Dilation;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.array.ArrayRandomAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.operators.Sub;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class MorphologyUtils {
    public static final <T> long[][] computeTargetImageDimensionsAndOffset(Interval source, Shape strel) {
        Neighborhood<BitType> sampleNeighborhood = MorphologyUtils.getNeighborhood(strel, source);
        int ndims = sampleNeighborhood.numDimensions();
        ndims = Math.max(ndims, source.numDimensions());
        long[] targetDims = new long[ndims];
        for (int d = 0; d < ndims; ++d) {
            long d1 = d < source.numDimensions() ? source.dimension(d) : 1L;
            long d2 = d < sampleNeighborhood.numDimensions() ? sampleNeighborhood.dimension(d) : 1L;
            targetDims[d] = d1 + d2 - 1L;
        }
        long[] offset = new long[source.numDimensions()];
        for (int d = 0; d < offset.length; ++d) {
            offset[d] = d < sampleNeighborhood.numDimensions() ? -sampleNeighborhood.min(d) : 0L;
        }
        return new long[][]{targetDims, offset};
    }

    static final void appendLine(RandomAccess<BitType> ra, long maxX, StringBuilder str) {
        long x;
        str.append('\u250c');
        for (x = 0L; x < maxX; ++x) {
            str.append('\u2500');
        }
        str.append("\u2510\n");
        str.append('\u2502');
        for (x = 0L; x < maxX; ++x) {
            ra.setPosition(x, 0);
            if (((BitType)ra.get()).get()) {
                str.append('\u2588');
                continue;
            }
            str.append(' ');
        }
        str.append("\u2502\n");
        str.append('\u2514');
        for (x = 0L; x < maxX; ++x) {
            str.append('\u2500');
        }
        str.append("\u2518\n");
    }

    private static final void appendManySlice(RandomAccess<BitType> ra, long maxX, long maxY, long maxZ, StringBuilder str) {
        long width = Math.max(maxX + 3L, 9L);
        int z = 0;
        while ((long)z < maxZ) {
            String sample = "Z = " + z + ":";
            str.append(sample);
            int i = 0;
            while ((long)i < width - (long)sample.length()) {
                str.append(' ');
                ++i;
            }
            ++z;
        }
        str.append('\n');
        z = 0;
        while ((long)z < maxZ) {
            str.append('\u250c');
            for (long x = 0L; x < maxX; ++x) {
                str.append('\u2500');
            }
            str.append("\u2510 ");
            int i = 0;
            while ((long)i < width - maxX - 3L) {
                str.append(' ');
                ++i;
            }
            ++z;
        }
        str.append('\n');
        for (long y = 0L; y < maxY; ++y) {
            ra.setPosition(y, 1);
            int z2 = 0;
            while ((long)z2 < maxZ) {
                ra.setPosition(z2, 2);
                str.append('\u2502');
                for (long x = 0L; x < maxX; ++x) {
                    ra.setPosition(x, 0);
                    if (((BitType)ra.get()).get()) {
                        str.append('\u2588');
                        continue;
                    }
                    str.append(' ');
                }
                str.append('\u2502');
                int i = 0;
                while ((long)i < width - maxX - 2L) {
                    str.append(' ');
                    ++i;
                }
                ++z2;
            }
            str.append('\n');
        }
        z = 0;
        while ((long)z < maxZ) {
            str.append('\u2514');
            for (long x = 0L; x < maxX; ++x) {
                str.append('\u2500');
            }
            str.append("\u2518 ");
            int i = 0;
            while ((long)i < width - maxX - 3L) {
                str.append(' ');
                ++i;
            }
            ++z;
        }
        str.append('\n');
    }

    private static final void appendSingleSlice(RandomAccess<BitType> ra, long maxX, long maxY, StringBuilder str) {
        long x;
        str.append('\u250c');
        for (x = 0L; x < maxX; ++x) {
            str.append('\u2500');
        }
        str.append("\u2510\n");
        for (long y = 0L; y < maxY; ++y) {
            str.append('\u2502');
            ra.setPosition(y, 1);
            for (long x2 = 0L; x2 < maxX; ++x2) {
                ra.setPosition(x2, 0);
                if (((BitType)ra.get()).get()) {
                    str.append('\u2588');
                    continue;
                }
                str.append(' ');
            }
            str.append("\u2502\n");
        }
        str.append('\u2514');
        for (x = 0L; x < maxX; ++x) {
            str.append('\u2500');
        }
        str.append("\u2518\n");
    }

    static <T extends Type<T>> void copy(final IterableInterval<T> source, final RandomAccessible<T> target, int numThreads) {
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(source.size(), numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int i = 0; i < threads.length; ++i) {
            final Chunk chunk = chunks.get(i);
            threads[i] = new Thread("Morphology copy thread " + i){

                @Override
                public void run() {
                    RealCursor sourceCursor = source.localizingCursor();
                    sourceCursor.jumpFwd(chunk.getStartPosition());
                    RandomAccess targetRandomAccess = target.randomAccess();
                    for (long step = 0L; step < chunk.getLoopSize(); ++step) {
                        sourceCursor.fwd();
                        targetRandomAccess.setPosition((Localizable)((Object)sourceCursor));
                        ((Type)targetRandomAccess.get()).set((Type)sourceCursor.get());
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    static <T extends Type<T>> void copy2(final RandomAccessible<T> source, final IterableInterval<T> target, int numThreads) {
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(target.size(), numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int i = 0; i < threads.length; ++i) {
            final Chunk chunk = chunks.get(i);
            threads[i] = new Thread("Morphology copy2 thread " + i){

                @Override
                public void run() {
                    RealCursor targetCursor = target.localizingCursor();
                    targetCursor.jumpFwd(chunk.getStartPosition());
                    RandomAccess sourceRandomAccess = source.randomAccess();
                    for (long step = 0L; step < chunk.getLoopSize(); ++step) {
                        targetCursor.fwd();
                        sourceRandomAccess.setPosition((Localizable)((Object)targetCursor));
                        ((Type)targetCursor.get()).set((Type)sourceRandomAccess.get());
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    static <T extends Type<T>> Img<T> copyCropped(final Img<T> largeSource, Interval interval, int numThreads) {
        final long[] offset = new long[largeSource.numDimensions()];
        for (int d = 0; d < offset.length; ++d) {
            offset[d] = (largeSource.dimension(d) - interval.dimension(d)) / 2L;
        }
        final Img<T> create = largeSource.factory().create(interval);
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(create.size(), numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int i = 0; i < threads.length; ++i) {
            final Chunk chunk = chunks.get(i);
            threads[i] = new Thread("Morphology copyCropped thread " + i){

                @Override
                public void run() {
                    IntervalView intervalView = Views.offset(largeSource, offset);
                    RealCursor cursor = create.cursor();
                    cursor.jumpFwd(chunk.getStartPosition());
                    RandomAccess randomAccess = intervalView.randomAccess();
                    for (long step = 0L; step < chunk.getLoopSize(); ++step) {
                        cursor.fwd();
                        randomAccess.setPosition((Localizable)((Object)cursor));
                        ((Type)cursor.get()).set((Type)randomAccess.get());
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
        return create;
    }

    static <T extends Type<T>> T createVariable(RandomAccessible<T> accessible, Interval interval) {
        RandomAccess<T> a = accessible.randomAccess();
        interval.min(a);
        return ((Type)a.get()).createVariable();
    }

    public static final Neighborhood<BitType> getNeighborhood(Shape shape, EuclideanSpace space) {
        int numDims = space.numDimensions();
        long[] dimensions = Util.getArrayFromValue(1L, numDims);
        ArrayImg<BitType, LongArray> img = ArrayImgs.bits(dimensions);
        IterableInterval neighborhoods = shape.neighborhoods(img);
        Neighborhood neighborhood = (Neighborhood)neighborhoods.cursor().next();
        return neighborhood;
    }

    public static final String printNeighborhood(Shape shape, int dimensionality) {
        long[] dimensions = Util.getArrayFromValue(1L, dimensionality);
        ArrayImg<BitType, LongArray> img = ArrayImgs.bits(dimensions);
        RandomAccess randomAccess = img.randomAccess();
        ((ArrayRandomAccess)randomAccess).setPosition(Util.getArrayFromValue(0, dimensions.length));
        ((BitType)((ArrayRandomAccess)randomAccess).get()).set(true);
        Img neighborhood = Dilation.dilateFull(img, shape, 1);
        StringBuilder str = new StringBuilder();
        for (int d = 3; d < neighborhood.numDimensions(); ++d) {
            if (neighborhood.dimension(d) <= 1L) continue;
            str.append("Cannot print structuring elements with n dimensions > 3.\nSkipping dimensions beyond 3.\n\n");
            break;
        }
        RandomAccess<BitType> randomAccess2 = neighborhood.randomAccess();
        if (neighborhood.numDimensions() > 2) {
            MorphologyUtils.appendManySlice(randomAccess2, neighborhood.dimension(0), neighborhood.dimension(1), neighborhood.dimension(2), str);
        } else if (neighborhood.numDimensions() > 1) {
            MorphologyUtils.appendSingleSlice(randomAccess2, neighborhood.dimension(0), neighborhood.dimension(1), str);
        } else if (neighborhood.numDimensions() > 0) {
            MorphologyUtils.appendLine(randomAccess2, neighborhood.dimension(0), str);
        } else {
            str.append("Void structuring element.\n");
        }
        return str.toString();
    }

    static <T extends Sub<T>> void subAAB(final RandomAccessible<T> A, final IterableInterval<T> B, int numThreads) {
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(B.size(), numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int i = 0; i < threads.length; ++i) {
            final Chunk chunk = chunks.get(i);
            threads[i] = new Thread("Morphology subAAB thread " + i){

                @Override
                public void run() {
                    RealCursor Bcursor = B.localizingCursor();
                    Bcursor.jumpFwd(chunk.getStartPosition());
                    RandomAccess Ara = A.randomAccess();
                    for (long step = 0L; step < chunk.getLoopSize(); ++step) {
                        Bcursor.fwd();
                        Ara.setPosition((Localizable)((Object)Bcursor));
                        ((Sub)Ara.get()).sub(Bcursor.get());
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    static <T extends Sub<T>> void subAAB2(final IterableInterval<T> A, final RandomAccessible<T> B, int numThreads) {
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(A.size(), numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int i = 0; i < threads.length; ++i) {
            final Chunk chunk = chunks.get(i);
            threads[i] = new Thread("Morphology subAAB2 thread " + i){

                @Override
                public void run() {
                    RealCursor Acursor = A.localizingCursor();
                    Acursor.jumpFwd(chunk.getStartPosition());
                    RandomAccess Bra = B.randomAccess();
                    for (long step = 0L; step < chunk.getLoopSize(); ++step) {
                        Acursor.fwd();
                        Bra.setPosition((Localizable)((Object)Acursor));
                        ((Sub)Acursor.get()).sub(Bra.get());
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    static <T extends Sub<T> & Type<T>> void subABA(final RandomAccessible<T> source, final IterableInterval<T> target, int numThreads) {
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(target.size(), numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int i = 0; i < threads.length; ++i) {
            final Chunk chunk = chunks.get(i);
            threads[i] = new Thread("Morphology subABA thread " + i){

                @Override
                public void run() {
                    Sub tmp = (Sub)MorphologyUtils.createVariable(source, target);
                    RealCursor targetCursor = target.localizingCursor();
                    targetCursor.jumpFwd(chunk.getStartPosition());
                    RandomAccess sourceRandomAccess = source.randomAccess();
                    for (long step = 0L; step < chunk.getLoopSize(); ++step) {
                        targetCursor.fwd();
                        sourceRandomAccess.setPosition((Localizable)((Object)targetCursor));
                        ((Type)((Object)tmp)).set((Type)targetCursor.get());
                        tmp.sub(sourceRandomAccess.get());
                        ((Type)((Object)((Sub)sourceRandomAccess.get()))).set((Type)((Object)tmp));
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    static <T extends Sub<T> & Type<T>> void subABA2(final RandomAccessibleInterval<T> source, final RandomAccessible<T> target, int numThreads) {
        long size = Intervals.numElements(source);
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(size, numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int i = 0; i < threads.length; ++i) {
            final Chunk chunk = chunks.get(i);
            threads[i] = new Thread("Morphology subABA2 thread " + i){

                @Override
                public void run() {
                    Sub tmp = (Sub)MorphologyUtils.createVariable(target, source);
                    RealCursor sourceCursor = Views.iterable(source).localizingCursor();
                    sourceCursor.jumpFwd(chunk.getStartPosition());
                    RandomAccess targetRandomAccess = target.randomAccess(source);
                    for (long step = 0L; step < chunk.getLoopSize(); ++step) {
                    }
                    while (sourceCursor.hasNext()) {
                        sourceCursor.fwd();
                        targetRandomAccess.setPosition((Localizable)((Object)sourceCursor));
                        ((Type)((Object)tmp)).set((Type)targetRandomAccess.get());
                        tmp.sub(sourceCursor.get());
                        ((Type)((Object)((Sub)targetRandomAccess.get()))).set((Type)((Object)tmp));
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    static <T extends Type<T> & Sub<T>> void subBAB(final RandomAccessible<T> A, final IterableInterval<T> B, int numThreads) {
        long size = Intervals.numElements(B);
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(size, numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        for (int i = 0; i < threads.length; ++i) {
            final Chunk chunk = chunks.get(i);
            threads[i] = new Thread("Morphology subBAB thread " + i){

                @Override
                public void run() {
                    Type tmp = MorphologyUtils.createVariable(A, B);
                    RealCursor BCursor = B.localizingCursor();
                    BCursor.jumpFwd(chunk.getStartPosition());
                    RandomAccess Ara = A.randomAccess();
                    for (long step = 0L; step < chunk.getLoopSize(); ++step) {
                        BCursor.fwd();
                        Ara.setPosition((Localizable)((Object)BCursor));
                        tmp.set((Type)((Type)Ara.get()));
                        ((Sub)((Object)tmp)).sub(BCursor.get());
                        ((Type)BCursor.get()).set(tmp);
                    }
                }
            };
        }
        SimpleMultiThreading.startAndJoin(threads);
    }
}

