/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Arrays;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodSkipCenter;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodSkipCenterUnsafe;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodUnsafe;
import net.imglib2.algorithm.neighborhood.RectangleShape;

public class GeneralRectangleShape
extends RectangleShape {
    final int offset;
    final int size;

    public GeneralRectangleShape(int size, int offset, boolean skipCenter) {
        super(-1, skipCenter);
        this.offset = offset;
        this.size = size;
    }

    @Override
    public <T> RectangleShape.NeighborhoodsIterableInterval<T> neighborhoods(RandomAccessibleInterval<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenterUnsafe.factory() : RectangleNeighborhoodUnsafe.factory();
        Interval spanInterval = this.createSpan(source.numDimensions());
        return new RectangleShape.NeighborhoodsIterableInterval<T>(source, spanInterval, f);
    }

    @Override
    public <T> RectangleShape.NeighborhoodsAccessible<T> neighborhoodsRandomAccessible(RandomAccessible<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenterUnsafe.factory() : RectangleNeighborhoodUnsafe.factory();
        Interval spanInterval = this.createSpan(source.numDimensions());
        return new RectangleShape.NeighborhoodsAccessible<T>(source, spanInterval, f);
    }

    @Override
    public <T> RectangleShape.NeighborhoodsIterableInterval<T> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenter.factory() : RectangleNeighborhood.factory();
        Interval spanInterval = this.createSpan(source.numDimensions());
        return new RectangleShape.NeighborhoodsIterableInterval<T>(source, spanInterval, f);
    }

    @Override
    public <T> RectangleShape.NeighborhoodsAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessible<T> source) {
        RectangleNeighborhoodFactory f = this.skipCenter ? RectangleNeighborhoodSkipCenter.factory() : RectangleNeighborhood.factory();
        Interval spanInterval = this.createSpan(source.numDimensions());
        return new RectangleShape.NeighborhoodsAccessible<T>(source, spanInterval, f);
    }

    private Interval createSpan(int n) {
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = this.offset;
            max[d] = this.size + this.offset - 1;
        }
        return new FinalInterval(min, max);
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public String toString() {
        return String.format("GeneralRectangleShape, size = %d, offset = %d  ", this.size, this.offset);
    }

    @Override
    public Interval getStructuringElementBoundingBox(int numDimensions) {
        long[] min = new long[numDimensions];
        Arrays.fill(min, (long)this.getOffset());
        long[] max = new long[numDimensions];
        Arrays.fill(max, (long)(this.getSize() + this.getOffset() - 1));
        return new FinalInterval(min, max);
    }
}

