/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.stream.LongStream;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.util.ConstantUtils;

public interface Shape {
    default public Interval getStructuringElementBoundingBox(int numDimensions) {
        RandomAccessible<Object> accessible = ConstantUtils.constantRandomAccessible(null, numDimensions);
        RandomAccess<Neighborhood<Object>> access = this.neighborhoodsRandomAccessible(accessible).randomAccess();
        access.setPosition(new long[numDimensions]);
        long[] min = LongStream.generate(() -> Long.MAX_VALUE).limit(numDimensions).toArray();
        long[] max = LongStream.generate(() -> Long.MIN_VALUE).limit(numDimensions).toArray();
        RealCursor cursor = ((Neighborhood)access.get()).localizingCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            for (int d = 0; d < numDimensions; ++d) {
                long pos = cursor.getLongPosition(d);
                min[d] = Math.min(pos, min[d]);
                max[d] = Math.max(pos, max[d]);
            }
        }
        return new FinalInterval(min, max);
    }

    public <T> IterableInterval<Neighborhood<T>> neighborhoods(RandomAccessibleInterval<T> var1);

    public <T> RandomAccessible<Neighborhood<T>> neighborhoodsRandomAccessible(RandomAccessible<T> var1);

    public <T> IterableInterval<Neighborhood<T>> neighborhoodsSafe(RandomAccessibleInterval<T> var1);

    public <T> RandomAccessible<Neighborhood<T>> neighborhoodsRandomAccessibleSafe(RandomAccessible<T> var1);
}

