/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.tac.expressions.CallExpression;
import org.renjin.compiler.ir.tac.expressions.Elipses;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.ExpressionVisitor;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.runtime.CompiledRuntime;
import org.renjin.compiler.runtime.UnimplementedPrimitive;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.WrapperGenerator2;
import org.renjin.primitives.Primitives;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class PrimitiveCall
implements CallExpression {
    private Symbol name;
    private FunctionCall call;
    private final List<Expression> arguments;
    private Method primitiveMethod;
    private String[] argumentNames;
    private int elipsesIndex;

    public PrimitiveCall(FunctionCall call2, Symbol name, List<Expression> arguments) {
        int i;
        this.call = call2;
        this.name = name;
        this.arguments = arguments;
        this.argumentNames = new String[arguments.size()];
        for (i = 0; i != this.argumentNames.length; ++i) {
            this.argumentNames[i] = Strings.emptyToNull((String)call2.getArguments().getName(i));
        }
        this.elipsesIndex = -1;
        for (i = 0; i != arguments.size(); ++i) {
            if (arguments.get(i) != Elipses.INSTANCE) continue;
            this.elipsesIndex = i;
            break;
        }
        this.primitiveMethod = this.findMethod(name, arguments.size());
    }

    private Method findMethod(Symbol name, int arity) {
        PrimitiveFunction fn = Primitives.getBuiltin(name);
        if (fn == null) {
            fn = Primitives.getInternal(name);
        }
        Class<?> wrapperClass = null;
        try {
            wrapperClass = Class.forName(WrapperGenerator2.toFullJavaName(fn.getName()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            return wrapperClass.getMethod("doApply", Context.class, Environment.class, FunctionCall.class, String[].class, SEXP[].class);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return null;
    }

    public PrimitiveCall(FunctionCall call2, String name, Expression ... arguments) {
        this(call2, Symbol.get(name), Lists.newArrayList((Object[])arguments));
    }

    public Symbol getName() {
        return this.name;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public Object retrieveValue(Context context, Object[] temps) {
        if (this.primitiveMethod == null) {
            throw new UnsupportedOperationException("doApply() method for " + this.name + " not found");
        }
        try {
            return this.applyStatic(context, temps);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof EvalException) {
                throw (EvalException)e.getCause();
            }
            throw new EvalException(e.getCause());
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
    }

    private SEXP applyStatic(Context context, Object[] temps) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String[] argumentNames = this.argumentNames;
        SEXP[] argumentValues = new SEXP[this.arguments.size()];
        for (int i = 0; i != this.arguments.size(); ++i) {
            if (this.arguments.get(i) == Elipses.INSTANCE) continue;
            argumentValues[i] = (SEXP)this.arguments.get(i).retrieveValue(context, temps);
        }
        if (this.elipsesIndex != -1) {
            PairList extraArgs = (PairList)context.getEnvironment().getVariable(Symbols.ELLIPSES);
            argumentNames = CompiledRuntime.spliceArgNames(argumentNames, extraArgs, this.elipsesIndex);
            argumentValues = CompiledRuntime.spliceArgValues(context, argumentValues, extraArgs, this.elipsesIndex);
        }
        return (SEXP)this.primitiveMethod.invoke(null, context, context.getEnvironment(), this.call, argumentNames, argumentValues);
    }

    public String toString() {
        String statement = this.name.getPrintName().equals(">") || this.name.getPrintName().equals("<") ? "primitive< " + this.name + " >" : "primitive<" + this.name + ">";
        return statement + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    @Override
    public Set<Variable> variables() {
        HashSet variables = Sets.newHashSet();
        for (Expression operand : this.arguments) {
            variables.addAll(operand.variables());
        }
        return Collections.unmodifiableSet(variables);
    }

    @Override
    public PrimitiveCall replaceVariable(Variable name, Variable newName) {
        ArrayList newOps = Lists.newArrayListWithCapacity((int)this.arguments.size());
        for (Expression argument : this.arguments) {
            newOps.add(argument.replaceVariable(name, newName));
        }
        return new PrimitiveCall(this.call, this.name, newOps);
    }

    @Override
    public List<Expression> getChildren() {
        return this.arguments;
    }

    @Override
    public void setChild(int i, Expression expr) {
        this.arguments.set(i, expr);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitPrimitiveCall(this);
    }

    @Override
    public FunctionCall getSExpression() {
        return this.call;
    }

    @Override
    public boolean hasElipses() {
        return this.elipsesIndex != -1;
    }

    @Override
    public int getElipsesIndex() {
        return this.elipsesIndex;
    }

    @Override
    public List<String> getArgumentNames() {
        return Arrays.asList(this.argumentNames);
    }

    public Class getWrapperClass() {
        if (this.primitiveMethod == null) {
            return UnimplementedPrimitive.class;
        }
        return this.primitiveMethod.getDeclaringClass();
    }
}

