/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.accessor;

import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.accessor.Accessor;
import org.renjin.compiler.pipeline.accessor.BinaryVectorOpAccessor;
import org.renjin.compiler.pipeline.accessor.DistanceMatrixAccessor;
import org.renjin.compiler.pipeline.accessor.DoubleArrayAccessor;
import org.renjin.compiler.pipeline.accessor.InputGraph;
import org.renjin.compiler.pipeline.accessor.IntArrayAccessor;
import org.renjin.compiler.pipeline.accessor.RepeatingAccessor;
import org.renjin.compiler.pipeline.accessor.TransposingAccessor;
import org.renjin.compiler.pipeline.accessor.UnaryVectorOpAccessor;
import org.renjin.compiler.pipeline.accessor.VirtualAccessor;
import org.renjin.primitives.matrix.TransposingMatrix;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.IntArrayVector;

public class Accessors {
    public static Accessor create(DeferredNode node, InputGraph inputGraph) {
        if (node.getVector() instanceof DoubleArrayVector) {
            return new DoubleArrayAccessor(inputGraph.getOperandIndex(node));
        }
        if (node.getVector() instanceof IntArrayVector) {
            return new IntArrayAccessor(inputGraph.getOperandIndex(node));
        }
        if (UnaryVectorOpAccessor.accept(node)) {
            return new UnaryVectorOpAccessor(node, inputGraph);
        }
        if (BinaryVectorOpAccessor.accept(node)) {
            return new BinaryVectorOpAccessor(node, inputGraph);
        }
        if (node.getVector() instanceof TransposingMatrix) {
            return new TransposingAccessor(node, inputGraph);
        }
        if (RepeatingAccessor.accept(node)) {
            return new RepeatingAccessor(node, inputGraph);
        }
        if (node.getVector() instanceof DeferredComputation && ((DeferredComputation)node.getVector()).getComputationName().equals("dist")) {
            return new DistanceMatrixAccessor(node, inputGraph);
        }
        return new VirtualAccessor(node.getVector(), inputGraph.getOperandIndex(node));
    }
}

