/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.accessor;

import org.objectweb.asm.MethodVisitor;
import org.renjin.compiler.pipeline.ComputeMethod;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.accessor.Accessor;
import org.renjin.compiler.pipeline.accessor.Accessors;
import org.renjin.compiler.pipeline.accessor.InputGraph;
import org.renjin.primitives.sequence.RepDoubleVector;

public class RepeatingAccessor
extends Accessor {
    private Accessor sourceAccessor;
    private Accessor timesAccessor;
    private int sourceLengthLocal;

    public RepeatingAccessor(DeferredNode node, InputGraph graph) {
        this.sourceAccessor = Accessors.create(node.getOperand(0), graph);
        this.timesAccessor = Accessors.create(node.getOperand(1), graph);
        if (!node.getOperand(2).hasValue(1.0)) {
            throw new IllegalArgumentException("each != 1 is not supported");
        }
    }

    public static boolean accept(DeferredNode node) {
        return node.getVector() instanceof RepDoubleVector;
    }

    @Override
    public void init(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        this.sourceAccessor.init(method);
        this.timesAccessor.init(method);
        this.sourceLengthLocal = method.reserveLocal(1);
        this.sourceAccessor.pushLength(method);
        mv.visitVarInsn(54, this.sourceLengthLocal);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(21, this.sourceLengthLocal);
        mv.visitInsn(3);
        this.timesAccessor.pushInt(method);
        mv.visitInsn(104);
    }

    @Override
    public void pushDouble(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(21, this.sourceLengthLocal);
        mv.visitInsn(112);
        this.sourceAccessor.pushDouble(method);
    }
}

