/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.renjin.eval.Context;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Symbols;

public class EvalException
extends RuntimeException {
    private SEXP condition;
    private Context context;

    public EvalException(String message, Throwable t2) {
        super(message, t2);
        ListVector.NamedBuilder condition = ListVector.newNamedBuilder();
        condition.add("message", this.getMessage());
        condition.setAttribute(Symbols.CLASS, (SEXP)new StringArrayVector("simpleError", "error", "condition"));
        this.condition = condition.build();
    }

    public EvalException(String message, Object ... args2) {
        this(args2.length == 0 ? message : String.format(message, args2), null);
    }

    public EvalException(Context context, String message, Object ... args2) {
        this(args2.length == 0 ? message : String.format(message, args2), null);
        this.context = context;
    }

    public EvalException(Throwable cause) {
        super(cause.getMessage(), cause);
    }

    public Context getContext() {
        return this.context;
    }

    public void initContext(Context context) {
        if (this.context == null) {
            this.context = context;
        }
    }

    public void printRStackTrace(PrintWriter writer) {
        if (this.context != null) {
            Context context = this.context;
            while (!context.isTopLevel()) {
                if (context.getType() == Context.Type.FUNCTION) {
                    writer.append("  at ").append(context.getFunctionName().toString()).append("()");
                    writer.append("\n");
                }
                context = context.getParent();
            }
            if (this.getCause() != null) {
                writer.append("Caused by:");
                Throwable excause = this.getCause();
                if (excause instanceof EvalException) {
                    ((EvalException)excause).printRStackTrace(writer);
                } else {
                    excause.printStackTrace(writer);
                }
            }
        } else {
            this.printStackTrace(writer);
        }
    }

    public void printRStackTrace(PrintStream stream) {
        PrintWriter writer = new PrintWriter(stream);
        this.printRStackTrace(writer);
        writer.flush();
    }

    public static void check(boolean condition, String errorMessage, Object ... args2) {
        if (!condition) {
            throw new EvalException(errorMessage, args2);
        }
    }

    public static <S extends SEXP> S checkedCast(SEXP argument) {
        try {
            return (S)argument;
        }
        catch (ClassCastException e) {
            throw new EvalException("invalid 'type' (%s) of argument", argument.getTypeName());
        }
    }

    public SEXP getCondition() {
        return this.condition;
    }
}

