/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen;

import java.util.Comparator;
import org.apache.commons.math.complex.Complex;
import org.renjin.invoke.codegen.scalars.ScalarTypes;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

class OverloadComparator
implements Comparator<JvmMethod> {
    private static final int ATOMIC_VECTOR_GROUP = 100;
    private static final int VECTOR_GROUP = 150;
    private static final int SEXP_GROUP = 200;
    private static final int OTHER_OBJECT = 300;

    OverloadComparator() {
    }

    @Override
    public int compare(JvmMethod o1, JvmMethod o2) {
        if (o1.getPositionalFormals().size() != o2.getPositionalFormals().size()) {
            return o1.getPositionalFormals().size() - o2.getPositionalFormals().size();
        }
        for (int i = 0; i != o1.getPositionalFormals().size(); ++i) {
            Class c2;
            Class c1 = o1.getPositionalFormals().get(i).getClazz();
            int cmp = this.compareArguments(c1, c2 = o2.getPositionalFormals().get(i).getClazz());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private int compareArguments(Class c1, Class c2) {
        int g1 = this.group(c1);
        int g2 = this.group(c2);
        try {
            if (g1 != g2) {
                return g1 - g2;
            }
            return this.compareIntraGroup(g1, c1, c2);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while comparing " + c1 + " and " + c2, e);
        }
    }

    private int group(Class clazz) {
        if (clazz.isPrimitive() || clazz.equals(Complex.class) || clazz.equals(String.class) || AtomicVector.class.isAssignableFrom(clazz)) {
            return 100;
        }
        if (Vector.class.isAssignableFrom(clazz)) {
            return 150;
        }
        if (SEXP.class.isAssignableFrom(clazz)) {
            return 200;
        }
        return 300;
    }

    private int compareIntraGroup(int group, Class c1, Class c2) {
        if (group == 100) {
            return this.compareVectors(c1, c2);
        }
        return this.compareClasses(c1, c2);
    }

    private int compareClasses(Class c1, Class c2) {
        int a = c1.isAssignableFrom(c2) ? 1 : 0;
        int b = c2.isAssignableFrom(c1) ? 1 : 0;
        return a - b;
    }

    private int compareVectors(Class c1, Class c2) {
        int cmp = this.compareClasses(c1, c2);
        if (cmp == 0) {
            Vector.Type t1 = this.vectorType(c1);
            Vector.Type t2 = this.vectorType(c2);
            cmp = t1.compareTo(t2);
        }
        return cmp;
    }

    private Vector.Type vectorType(Class clazz) {
        if (clazz.isPrimitive()) {
            return ScalarTypes.get(clazz).getVectorTypeInstance();
        }
        if (clazz.equals(Complex.class)) {
            return ComplexVector.VECTOR_TYPE;
        }
        if (clazz.equals(String.class)) {
            return StringVector.VECTOR_TYPE;
        }
        try {
            return (Vector.Type)clazz.getField("VECTOR_TYPE").get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get VECTOR_TYPE from " + clazz.getName(), e);
        }
    }
}

