/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import java.lang.reflect.Array;
import org.renjin.eval.EvalException;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;

public class IntegerArrayConverter
implements Converter<Object> {
    public static final IntegerArrayConverter INSTANCE = new IntegerArrayConverter();

    private IntegerArrayConverter() {
    }

    @Override
    public SEXP convertToR(Object value) {
        if (value == null) {
            return new IntArrayVector(Integer.MIN_VALUE);
        }
        int[] iArray = new int[Array.getLength(value)];
        for (int i = 0; i < Array.getLength(value); ++i) {
            iArray[i] = ((Number)Array.get(value, i)).intValue();
        }
        return new IntArrayVector(iArray);
    }

    public static boolean accept(Class clazz) {
        Class<?> iclazz = clazz.getComponentType();
        return clazz.isArray() && (iclazz == Integer.TYPE || iclazz == Integer.class || iclazz == Short.TYPE || iclazz == Short.class);
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        return exp2 instanceof IntVector;
    }

    @Override
    public int getSpecificity() {
        return 2;
    }

    @Override
    public Object convertToJava(SEXP value) {
        if (!(value instanceof AtomicVector)) {
            throw new EvalException("It's not an AtomicVector", value.getTypeName());
        }
        if (value.length() < 1) {
            return new Integer[0];
        }
        IntVector lv = (IntVector)value;
        int length2 = lv.length();
        Integer[] values = new Integer[length2];
        for (int i = 0; i < length2; ++i) {
            values[i] = lv.getElementAsObject(i);
        }
        return values;
    }
}

