/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Unevaluated;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;

public class Comparison {
    private Comparison() {
    }

    @Builtin(value="||")
    public static LogicalVector or(@Current Context context, @Current Environment rho, @Unevaluated SEXP xExp, @Unevaluated SEXP yExp) {
        Logical x = Comparison.checkedToLogical(context.evaluate(xExp, rho), "invalid 'x' type in 'x || y'");
        if (x == Logical.TRUE) {
            return LogicalVector.TRUE;
        }
        Logical y = Comparison.checkedToLogical(context.evaluate(yExp, rho), "invalid 'y' type in 'x || y'");
        if (y == Logical.TRUE) {
            return LogicalVector.TRUE;
        }
        if (x == Logical.NA || y == Logical.NA) {
            return LogicalVector.NA_VECTOR;
        }
        return LogicalVector.FALSE;
    }

    @Builtin(value="&&")
    public static LogicalVector and(@Current Context context, @Current Environment rho, @Unevaluated SEXP xExp, @Unevaluated SEXP yExp) {
        Logical x = Comparison.checkedToLogical(context.evaluate(xExp, rho), "invalid 'x' type in 'x && y'");
        if (x == Logical.FALSE) {
            return LogicalVector.FALSE;
        }
        Logical y = Comparison.checkedToLogical(context.evaluate(yExp, rho), "invalid 'y' type in 'x && y'");
        if (y == Logical.FALSE) {
            return LogicalVector.FALSE;
        }
        if (x == Logical.TRUE && y == Logical.TRUE) {
            return LogicalVector.TRUE;
        }
        return LogicalVector.NA_VECTOR;
    }

    private static Logical checkedToLogical(SEXP exp2, String errorMessage) {
        if (exp2 instanceof AtomicVector) {
            AtomicVector vector2 = (AtomicVector)exp2;
            if (vector2.length() == 0) {
                return Logical.NA;
            }
            return vector2.getElementAsLogical(0);
        }
        throw new EvalException(errorMessage, new Object[0]);
    }
}

